/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.credentials;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class SshCredentialsProperties
extends SharedCredentialsProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials");
    private final String key;
    private final String passphrase;

    private SshCredentialsProperties() {
        this.key = null;
        this.passphrase = null;
    }

    public SshCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid, @NotNull String key, @Nullable String passphrase) throws PropertiesValidationException {
        this(name, oid, key, passphrase, null);
    }

    public SshCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid, @NotNull String key, @Nullable String passphrase, @Nullable ProjectProperties project) throws PropertiesValidationException {
        super(name, oid, project);
        this.key = key;
        this.passphrase = passphrase;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshCredentialsProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SshCredentialsProperties that = (SshCredentialsProperties)((Object)o);
        return Objects.equals(this.key, that.key) && Objects.equals(this.passphrase, that.passphrase);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.passphrase);
    }

    public String toString() {
        return "SshCredentialsProperties{key='" + this.key + "', passphrase='" + this.passphrase + "'}";
    }

    public void validate() {
        super.validate();
    }
}

