/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsScope;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.codegen.CompoundFieldSetterEmitter;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.builders.task.DockerPullImageTask;
import com.atlassian.bamboo.specs.builders.task.DockerPushImageTask;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerRegistryEmitter
extends EntityPropertiesEmitter<DockerRegistryTaskProperties> {
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull DockerRegistryTaskProperties entity) throws CodeGenerationException {
        switch (entity.getOperationType()) {
            case PUSH: {
                this.builderClass = DockerPushImageTask.class;
                break;
            }
            case PULL: {
                this.builderClass = DockerPullImageTask.class;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operation type: " + String.valueOf((Object)entity.getOperationType()));
            }
        }
        return super.emitCode(context, entity);
    }

    private static String escapeString(String property) {
        return property.replaceAll("\"", "\\\\\"");
    }

    public static class ImageEmitter
    implements CompoundFieldSetterEmitter<DockerRegistryTaskProperties> {
        @NotNull
        public String emitCode(@NotNull CodeGenerationContext context, DockerRegistryTaskProperties entity) throws CodeGenerationException {
            switch (entity.getRegistryType()) {
                case DOCKER_HUB: {
                    return String.format(".dockerHubImage(\"%s\")", entity.getImage());
                }
                case CUSTOM: {
                    return String.format(".customRegistryImage(\"%s\")", entity.getImage());
                }
            }
            throw new IllegalStateException("Invalid registry type: " + String.valueOf((Object)entity.getOperationType()));
        }
    }

    public static class AuthEmitter
    implements CompoundFieldSetterEmitter<DockerRegistryTaskProperties> {
        @NotNull
        public String emitCode(@NotNull CodeGenerationContext context, DockerRegistryTaskProperties entity) throws CodeGenerationException {
            SharedCredentialsIdentifierProperties sharedCredentials = entity.getSharedCredentialsIdentifier();
            if (sharedCredentials != null) {
                return String.format(".authentication(new %s(\"%s\").scope(%s.%s))", context.importClassName(SharedCredentialsIdentifier.class), sharedCredentials.getName(), context.importClassName(SharedCredentialsScope.class), sharedCredentials.getScope());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getUsername()) && StringUtils.isNotBlank((CharSequence)entity.getPassword())) {
                String escapedUsername = DockerRegistryEmitter.escapeString(entity.getUsername());
                String escapedPassword = DockerRegistryEmitter.escapeString(entity.getPassword());
                if (StringUtils.isNotBlank((CharSequence)entity.getEmail())) {
                    String escapedEmail = DockerRegistryEmitter.escapeString(entity.getEmail());
                    return String.format(".authentication(\"%s\",\"%s\",\"%s\")", escapedUsername, escapedPassword, escapedEmail);
                }
                return String.format(".authentication(\"%s\",\"%s\")", escapedUsername, escapedPassword);
            }
            return ".defaultAuthentication()";
        }
    }
}

