/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.NUnitRunnerTaskProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NUnitRunnerTask
extends Task<NUnitRunnerTask, NUnitRunnerTaskProperties> {
    private String executable;
    private NUnitVersion nUnitVersion;
    private String nUnitTestFiles;
    private String resultFilename;
    private List<String> testsToRun = new ArrayList<String>();
    private List<String> testCategoriesToInclude = new ArrayList<String>();
    private List<String> testCategoriesToExclude = new ArrayList<String>();
    private String commandLineOptions;
    private String environmentVariables;

    public NUnitRunnerTask executable(@NotNull String executable) {
        ImporterUtils.checkNotNull((String)"executable", (Object)executable);
        this.executable = executable;
        return this;
    }

    public NUnitRunnerTask nUnitVersion2() {
        return this.nUnitVersion(NUnitVersion.NUNIT_2);
    }

    public NUnitRunnerTask nUnitVersion3() {
        return this.nUnitVersion(NUnitVersion.NUNIT_3);
    }

    private NUnitRunnerTask nUnitVersion(@NotNull NUnitVersion nUnitVersion) {
        ImporterUtils.checkNotNull((String)"nUnitVersion", (Object)((Object)nUnitVersion));
        this.nUnitVersion = nUnitVersion;
        return this;
    }

    public NUnitRunnerTask nUnitTestFiles(@NotNull String nUnitTestFiles) {
        ImporterUtils.checkNotNull((String)"nUnitTestFiles", (Object)nUnitTestFiles);
        this.nUnitTestFiles = nUnitTestFiles;
        return this;
    }

    public NUnitRunnerTask resultFilename(@NotNull String resultFilename) {
        ImporterUtils.checkNotNull((String)"resultFilename", (Object)resultFilename);
        this.resultFilename = resultFilename;
        return this;
    }

    public NUnitRunnerTask testsToRun(String ... testsToRun) {
        ImporterUtils.checkNotNull((String)"testsToRun", (Object)testsToRun);
        Arrays.stream(testsToRun).forEach(this.testsToRun::add);
        return this;
    }

    public NUnitRunnerTask testCategoriesToInclude(String ... testCategoriesToInclude) {
        ImporterUtils.checkNotNull((String)"testCategoriesToInclude", (Object)testCategoriesToInclude);
        Arrays.stream(testCategoriesToInclude).forEach(this.testCategoriesToInclude::add);
        return this;
    }

    public NUnitRunnerTask testCategoriesToExclude(String ... testCategoriesToExclude) {
        ImporterUtils.checkNotNull((String)"testCategoriesToExclude", (Object)testCategoriesToExclude);
        Arrays.stream(testCategoriesToExclude).forEach(this.testCategoriesToExclude::add);
        return this;
    }

    public NUnitRunnerTask commandLineOptions(@Nullable String commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
        return this;
    }

    public NUnitRunnerTask environmentVariables(@Nullable String environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    @NotNull
    protected NUnitRunnerTaskProperties build() {
        return new NUnitRunnerTaskProperties(this.description, this.taskEnabled, this.executable, this.nUnitVersion, this.nUnitTestFiles, this.resultFilename, this.testsToRun, this.testCategoriesToInclude, this.testCategoriesToExclude, this.commandLineOptions, this.environmentVariables, this.requirements, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NUnitRunnerTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NUnitRunnerTask that = (NUnitRunnerTask)((Object)o);
        return Objects.equals(this.executable, that.executable) && this.nUnitVersion == that.nUnitVersion && Objects.equals(this.nUnitTestFiles, that.nUnitTestFiles) && Objects.equals(this.resultFilename, that.resultFilename) && Objects.equals(this.testsToRun, that.testsToRun) && Objects.equals(this.testCategoriesToInclude, that.testCategoriesToInclude) && Objects.equals(this.testCategoriesToExclude, that.testCategoriesToExclude) && Objects.equals(this.commandLineOptions, that.commandLineOptions) && Objects.equals(this.environmentVariables, that.environmentVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.executable, this.nUnitVersion, this.nUnitTestFiles, this.resultFilename, this.testsToRun, this.testCategoriesToInclude, this.testCategoriesToExclude, this.commandLineOptions, this.environmentVariables});
    }

    public static enum NUnitVersion {
        NUNIT_2,
        NUNIT_3;

    }
}

