/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.MsBuildTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsBuildTask
extends Task<MsBuildTask, MsBuildTaskProperties> {
    public static final String DEFAULT_PROJECT = "YourSolution.sln";
    private String executable;
    private String projectFile = "YourSolution.sln";
    private String options;
    private String environmentVariables;
    private String workingSubdirectory;

    public MsBuildTask executable(@NotNull String executable) {
        ImporterUtils.checkNotBlank((String)"executable", (String)executable);
        this.executable = executable;
        return this;
    }

    public MsBuildTask projectFile(@NotNull String projectFile) {
        ImporterUtils.checkNotBlank((String)"projectFile", (String)projectFile);
        this.projectFile = projectFile;
        return this;
    }

    public MsBuildTask options(@Nullable String options) {
        this.options = options;
        return this;
    }

    public MsBuildTask environmentVariables(@Nullable String environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public MsBuildTask workingSubdirectory(@Nullable String workingSubdirectory) {
        this.workingSubdirectory = workingSubdirectory;
        return this;
    }

    @NotNull
    protected MsBuildTaskProperties build() {
        return new MsBuildTaskProperties(this.description, this.taskEnabled, this.executable, this.projectFile, this.options, this.environmentVariables, this.workingSubdirectory, this.requirements, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MsBuildTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MsBuildTask that = (MsBuildTask)((Object)o);
        return Objects.equals(this.executable, that.executable) && Objects.equals(this.projectFile, that.projectFile) && Objects.equals(this.options, that.options) && Objects.equals(this.environmentVariables, that.environmentVariables) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.executable, this.projectFile, this.options, this.environmentVariables, this.workingSubdirectory);
    }
}

