/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.model.task.MavenTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenTask
extends Task<MavenTask, MavenTaskProperties> {
    public static final int MAVEN_V2 = 2;
    public static final int MAVEN_V3 = 3;
    @NotNull
    protected String goal;
    @Nullable
    protected String projectFile;
    @Nullable
    protected String environmentVariables;
    @Nullable
    protected String jdk;
    @Nullable
    protected String label;
    protected boolean hasTests;
    @Nullable
    protected TestDirectoryOption testDirectoryOption;
    @Nullable
    protected String testResultsDirectory;
    @Nullable
    protected String workingSubdirectory;
    protected boolean useMavenReturnCode;
    protected int version = 3;

    public MavenTask goal(@NotNull String goal) {
        this.goal = goal;
        return this;
    }

    public MavenTask projectFile(String projectFile) {
        this.projectFile = projectFile;
        return this;
    }

    public MavenTask environmentVariables(String environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public MavenTask jdk(String jdk) {
        this.jdk = jdk;
        return this;
    }

    public MavenTask executableLabel(String label) {
        this.label = label;
        return this;
    }

    public MavenTask hasTests(boolean hasTests) {
        this.hasTests = hasTests;
        return this;
    }

    public MavenTask standardResultsPath() {
        this.testDirectoryOption = TestDirectoryOption.STANDARD;
        return this;
    }

    public MavenTask testResultsPath(String testResultsDirectory) {
        this.testDirectoryOption = TestDirectoryOption.CUSTOM;
        this.testResultsDirectory = testResultsDirectory;
        return this;
    }

    public MavenTask workingSubdirectory(String workingSubdirectory) {
        this.workingSubdirectory = workingSubdirectory;
        return this;
    }

    public MavenTask useMavenReturnCode(boolean useMavenReturnCode) {
        this.useMavenReturnCode = useMavenReturnCode;
        return this;
    }

    public MavenTask version2() {
        this.version = 2;
        return this;
    }

    public MavenTask version3() {
        this.version = 3;
        return this;
    }

    @NotNull
    protected MavenTaskProperties build() {
        return new MavenTaskProperties(this.description, this.taskEnabled, this.goal, this.projectFile, this.environmentVariables, this.jdk, this.label, this.hasTests, this.testDirectoryOption, this.testResultsDirectory, this.workingSubdirectory, this.useMavenReturnCode, this.version, this.requirements, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenTask mavenTask = (MavenTask)((Object)o);
        return this.hasTests == mavenTask.hasTests && this.useMavenReturnCode == mavenTask.useMavenReturnCode && this.version == mavenTask.version && this.goal.equals(mavenTask.goal) && Objects.equals(this.projectFile, mavenTask.projectFile) && Objects.equals(this.environmentVariables, mavenTask.environmentVariables) && Objects.equals(this.jdk, mavenTask.jdk) && Objects.equals(this.label, mavenTask.label) && this.testDirectoryOption == mavenTask.testDirectoryOption && Objects.equals(this.testResultsDirectory, mavenTask.testResultsDirectory) && Objects.equals(this.workingSubdirectory, mavenTask.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.goal, this.projectFile, this.environmentVariables, this.jdk, this.label, this.hasTests, this.testDirectoryOption, this.testResultsDirectory, this.workingSubdirectory, this.useMavenReturnCode, this.version});
    }

    public static enum TestDirectoryOption {
        STANDARD,
        CUSTOM;

    }
}

