/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.task.BaseNodeTask;
import com.atlassian.bamboo.specs.model.task.GruntTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTask
extends BaseNodeTask<GruntTask, GruntTaskProperties> {
    public static final String DEFAULT_GRUNT_CLI_EXECUTABLE = InliningUtils.preventInlining((String)"node_modules/grunt-cli/bin/grunt");
    @NotNull
    private String gruntCliExecutable = DEFAULT_GRUNT_CLI_EXECUTABLE;
    @Nullable
    private String task;
    @Nullable
    private String gruntfile;

    public GruntTask gruntCliExecutable(@NotNull String gruntCliExecutable) {
        ImporterUtils.checkNotNull((String)"gruntCliExecutable", (Object)gruntCliExecutable);
        this.gruntCliExecutable = gruntCliExecutable;
        return this;
    }

    public GruntTask task(@Nullable String task) {
        this.task = task;
        return this;
    }

    public GruntTask gruntfile(@Nullable String gruntfile) {
        this.gruntfile = gruntfile;
        return this;
    }

    @NotNull
    protected GruntTaskProperties build() {
        return new GruntTaskProperties(this.description, this.taskEnabled, this.nodeExecutable, this.environmentVariables, this.workingSubdirectory, this.gruntCliExecutable, this.task, this.gruntfile, this.requirements, this.conditions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GruntTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GruntTask gruntTask = (GruntTask)((Object)o);
        return this.gruntCliExecutable.equals(gruntTask.gruntCliExecutable) && Objects.equals(this.task, gruntTask.task) && Objects.equals(this.gruntfile, gruntTask.gruntfile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gruntCliExecutable, this.task, this.gruntfile);
    }
}

