/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.BuildWarningParserTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildWarningParserTask
extends Task<BuildWarningParserTask, BuildWarningParserTaskProperties> {
    private String parser;
    @Nullable
    private String filePattern;
    private boolean associateWithRepository;
    private boolean defaultRepository;
    @Nullable
    private VcsRepositoryIdentifierProperties repository;
    private boolean failBuild;
    private int failBuildThreshold;
    private WarningSeverity failBuildSeverity = WarningSeverity.LOW;

    public BuildWarningParserTask defaultRepository() {
        this.associateWithRepository = true;
        this.defaultRepository = true;
        this.repository = null;
        return this;
    }

    public BuildWarningParserTask repository(@NotNull String repositoryName) {
        ImporterUtils.checkNotNull((String)"repositoryName", (Object)repositoryName);
        this.associateWithRepository = true;
        this.defaultRepository = false;
        return this.repository(new VcsRepositoryIdentifier().name(repositoryName));
    }

    public BuildWarningParserTask repository(@NotNull VcsRepositoryIdentifier repositoryIdentifier) {
        ImporterUtils.checkNotNull((String)"repositoryIdentifier", (Object)repositoryIdentifier);
        this.associateWithRepository = true;
        this.defaultRepository = false;
        this.repository = (VcsRepositoryIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)repositoryIdentifier);
        return this;
    }

    public BuildWarningParserTask noRepository() {
        this.associateWithRepository = false;
        this.defaultRepository = false;
        this.repository = null;
        return this;
    }

    public BuildWarningParserTask parser(@NotNull String parser) {
        ImporterUtils.checkNotBlank((String)"parser", (String)parser);
        this.parser = parser;
        return this;
    }

    public BuildWarningParserTask parseLogs() {
        this.filePattern = null;
        return this;
    }

    public BuildWarningParserTask parseFiles(@NotNull String globPattern) {
        this.filePattern = globPattern;
        return this;
    }

    public BuildWarningParserTask failBuild(boolean failBuild) {
        this.failBuild = failBuild;
        return this;
    }

    public BuildWarningParserTask failBuildThreshold(int failBuildThreshold) {
        ImporterUtils.checkNotNegative((String)"failBuildThreshold", (int)failBuildThreshold);
        this.failBuildThreshold = failBuildThreshold;
        return this;
    }

    public BuildWarningParserTask failBuildSeverity(@NotNull WarningSeverity failBuildSeverity) {
        ImporterUtils.checkNotNull((String)"failBuildSeverity", (Object)((Object)failBuildSeverity));
        this.failBuildSeverity = failBuildSeverity;
        return this;
    }

    @NotNull
    protected BuildWarningParserTaskProperties build() {
        return new BuildWarningParserTaskProperties(this.description, this.taskEnabled, this.requirements, this.conditions, this.parser, this.filePattern, this.associateWithRepository, this.defaultRepository, this.repository, this.failBuild, this.failBuildThreshold, this.failBuildSeverity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildWarningParserTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildWarningParserTask that = (BuildWarningParserTask)((Object)o);
        return this.associateWithRepository == that.associateWithRepository && this.defaultRepository == that.defaultRepository && this.failBuild == that.failBuild && this.failBuildThreshold == that.failBuildThreshold && Objects.equals(this.parser, that.parser) && Objects.equals(this.filePattern, that.filePattern) && Objects.equals(this.repository, that.repository) && this.failBuildSeverity == that.failBuildSeverity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.parser, this.filePattern, this.associateWithRepository, this.defaultRepository, this.repository, this.failBuild, this.failBuildThreshold, this.failBuildSeverity});
    }

    public static enum WarningSeverity {
        LOW,
        NORMAL,
        HIGH;

    }
}

