/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.repository.bitbucket.cloud;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.repository.bitbucket.cloud.EmailApiTokenAuthentication;
import com.atlassian.bamboo.specs.builders.repository.git.SshPrivateKeyAuthentication;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.builders.repository.viewer.BitbucketCloudRepositoryViewer;
import com.atlassian.bamboo.specs.model.repository.bitbucket.cloud.BitbucketCloudRepositoryProperties;
import com.atlassian.bamboo.specs.model.repository.bitbucket.cloud.EmailApiTokenAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.SharedCredentialsAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.UserPasswordAuthenticationProperties;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class BitbucketCloudRepository
extends VcsRepository<BitbucketCloudRepository, BitbucketCloudRepositoryProperties> {
    private String repositorySlug;
    private String branch;
    private boolean useShallowClones = false;
    private boolean useRemoteAgentCache = false;
    private boolean useSubmodules = false;
    private boolean sshKeyAppliesToSubmodules;
    private Duration commandTimeout = BitbucketCloudRepositoryProperties.DEFAULT_COMMAND_TIMEOUT;
    private boolean verboseLogs = false;
    private boolean fetchWholeRepository = false;
    private boolean useLfs = false;
    private boolean webhookEnabled = false;
    private AuthenticationProperties accountAuthentication;
    private AuthenticationProperties checkoutAuthentication;
    private VcsChangeDetectionProperties vcsChangeDetection;

    public BitbucketCloudRepository() throws PropertiesValidationException {
        this.repositoryViewer(new BitbucketCloudRepositoryViewer());
    }

    public BitbucketCloudRepository repositorySlug(@NotNull String owner, @NotNull String repositorySlug) {
        ImporterUtils.checkNotBlank((String)"owner", (String)owner);
        ImporterUtils.checkNotBlank((String)"repositorySlug", (String)repositorySlug);
        this.repositorySlug = String.format("%s/%s", owner, repositorySlug);
        return this;
    }

    public BitbucketCloudRepository branch(@NotNull String branch) {
        ImporterUtils.checkNotNull((String)"branch", (Object)branch);
        this.branch = branch;
        return this;
    }

    public BitbucketCloudRepository shallowClonesEnabled(boolean useShallowClones) {
        this.useShallowClones = useShallowClones;
        return this;
    }

    public BitbucketCloudRepository sshKeyAppliesToSubmodules(boolean sshKeyAppliesToSubmodules) {
        this.sshKeyAppliesToSubmodules = sshKeyAppliesToSubmodules;
        return this;
    }

    public BitbucketCloudRepository submodulesEnabled(boolean useSubmodules) {
        this.useSubmodules = useSubmodules;
        return this;
    }

    public BitbucketCloudRepository remoteAgentCacheEnabled(boolean useRemoteAgentCache) {
        this.useRemoteAgentCache = useRemoteAgentCache;
        return this;
    }

    public BitbucketCloudRepository commandTimeout(Duration commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public BitbucketCloudRepository commandTimeoutInMinutes(int commandTimeoutMinutes) {
        return this.commandTimeout(Duration.ofMinutes(commandTimeoutMinutes));
    }

    public BitbucketCloudRepository verboseLogs(boolean verboseLogs) {
        this.verboseLogs = verboseLogs;
        return this;
    }

    public BitbucketCloudRepository fetchWholeRepository(boolean fetchWholeRepository) {
        this.fetchWholeRepository = fetchWholeRepository;
        return this;
    }

    public BitbucketCloudRepository lfsEnabled(boolean useLfs) {
        this.useLfs = useLfs;
        return this;
    }

    public BitbucketCloudRepository webhookEnabled(boolean webhookEnabled) {
        this.webhookEnabled = webhookEnabled;
        return this;
    }

    public BitbucketCloudRepository defaultChangeDetection() {
        this.vcsChangeDetection = null;
        return this;
    }

    public BitbucketCloudRepository changeDetection(VcsChangeDetection vcsChangeDetection) {
        this.vcsChangeDetection = (VcsChangeDetectionProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)vcsChangeDetection);
        return this;
    }

    public BitbucketCloudRepository accountAuthentication(@NotNull SharedCredentialsIdentifier sharedCredentialsIdentifier) {
        ImporterUtils.checkNotNull((String)"sharedCredentialsIdentifier", (Object)sharedCredentialsIdentifier);
        this.accountAuthentication = new SharedCredentialsAuthenticationProperties((SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentialsIdentifier));
        return this;
    }

    @Deprecated
    public BitbucketCloudRepository accountAuthentication(@NotNull UserPasswordAuthentication userPasswordAuthentication) {
        ImporterUtils.checkNotNull((String)"userPasswordAuthentication", (Object)((Object)userPasswordAuthentication));
        UserPasswordAuthenticationProperties userAuthProperties = (UserPasswordAuthenticationProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)userPasswordAuthentication);
        ImporterUtils.checkNotBlank((String)"password", (String)userAuthProperties.getPassword());
        this.accountAuthentication = userAuthProperties;
        return this;
    }

    public BitbucketCloudRepository accountAuthentication(@NotNull EmailApiTokenAuthentication emailApiTokenAuthentication) {
        ImporterUtils.checkNotNull((String)"emailApiTokenAuthentication", (Object)((Object)emailApiTokenAuthentication));
        EmailApiTokenAuthenticationProperties emailApiTokenAuthProperties = (EmailApiTokenAuthenticationProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)emailApiTokenAuthentication);
        ImporterUtils.checkNotBlank((String)"apiToken", (String)emailApiTokenAuthProperties.getApiToken());
        this.accountAuthentication = emailApiTokenAuthProperties;
        return this;
    }

    public BitbucketCloudRepository checkoutAuthentication(@NotNull SharedCredentialsIdentifier sharedCredentialsIdentifier) {
        ImporterUtils.checkNotNull((String)"sharedCredentialsIdentifier", (Object)sharedCredentialsIdentifier);
        this.checkoutAuthentication = new SharedCredentialsAuthenticationProperties((SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentialsIdentifier));
        return this;
    }

    public BitbucketCloudRepository checkoutAuthentication(@NotNull SshPrivateKeyAuthentication sshPrivateKeyAuthentication) {
        ImporterUtils.checkNotNull((String)"sshPrivateKeyAuthentication", (Object)((Object)sshPrivateKeyAuthentication));
        this.checkoutAuthentication = (AuthenticationProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sshPrivateKeyAuthentication);
        return this;
    }

    protected BitbucketCloudRepositoryProperties build() throws PropertiesValidationException {
        return new BitbucketCloudRepositoryProperties(this.name, this.oid, this.description, this.parent, this.repositoryViewer, this.repositorySlug, this.accountAuthentication, this.checkoutAuthentication, this.branch, this.project, this.useShallowClones, this.useRemoteAgentCache, this.useSubmodules, this.sshKeyAppliesToSubmodules, this.commandTimeout, this.verboseLogs, this.fetchWholeRepository, this.useLfs, this.webhookEnabled, this.vcsChangeDetection);
    }
}

