/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsScope;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.builders.task.DockerPullImageTask;
import com.atlassian.bamboo.specs.builders.task.DockerPushImageTask;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerRegistryEmitter
extends EntityPropertiesEmitter<DockerRegistryTaskProperties> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull DockerRegistryTaskProperties entity) throws CodeGenerationException {
        switch (entity.getOperationType()) {
            case PUSH: {
                this.builderClass = DockerPushImageTask.class;
                break;
            }
            case PULL: {
                this.builderClass = DockerPullImageTask.class;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operation type: " + entity.getOperationType());
            }
        }
        this.fieldsToSkip.add("operationType");
        this.fieldsToSkip.add("registryType");
        this.fieldsToSkip.add("image");
        this.fieldsToSkip.add("username");
        this.fieldsToSkip.add("password");
        this.fieldsToSkip.add("email");
        String constructorInvocation = this.emitConstructorInvocation(context, entity);
        context.incIndentation();
        try {
            Object format = "%s%s.%s%s.%s";
            ArrayList<String> params = new ArrayList<String>();
            params.add(constructorInvocation);
            params.add(context.newLine());
            params.add(this.emitImageCode(entity));
            params.add(context.newLine());
            params.add(this.emitAuthenticationCode(entity, context));
            if (StringUtils.isNotEmpty((CharSequence)entity.getDescription())) {
                format = (String)format + "%s.%s";
                params.add(context.newLine());
                params.add(this.emitDescriptionCode(entity));
            }
            String string = String.format((String)format, params.toArray());
            return string;
        }
        finally {
            context.decIndentation();
        }
    }

    protected String emitAuthenticationCode(DockerRegistryTaskProperties entity, CodeGenerationContext context) {
        SharedCredentialsIdentifierProperties sharedCredentials = entity.getSharedCredentialsIdentifier();
        if (sharedCredentials != null) {
            return String.format("authentication(new %s(\"%s\").scope(%s.%s))", context.importClassName(SharedCredentialsIdentifier.class), sharedCredentials.getName(), context.importClassName(SharedCredentialsScope.class), sharedCredentials.getScope());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getUsername()) && StringUtils.isNotBlank((CharSequence)entity.getPassword())) {
            String escapedUsername = this.escapeString(entity.getUsername());
            String escapedPassword = this.escapeString(entity.getPassword());
            if (StringUtils.isNotBlank((CharSequence)entity.getEmail())) {
                String escapedEmail = this.escapeString(entity.getEmail());
                return String.format("authentication(\"%s\",\"%s\",\"%s\")", escapedUsername, escapedPassword, escapedEmail);
            }
            return String.format("authentication(\"%s\",\"%s\")", escapedUsername, escapedPassword);
        }
        return "defaultAuthentication()";
    }

    private String escapeString(String property) {
        return property.replaceAll("\"", "\\\\\"");
    }

    protected String emitImageCode(DockerRegistryTaskProperties entity) {
        switch (entity.getRegistryType()) {
            case DOCKER_HUB: {
                return String.format("dockerHubImage(\"%s\")", entity.getImage());
            }
            case CUSTOM: {
                return String.format("customRegistryImage(\"%s\")", entity.getImage());
            }
        }
        throw new IllegalStateException("Invalid registry type: " + entity.getOperationType());
    }

    protected String emitDescriptionCode(DockerRegistryTaskProperties entity) {
        return String.format("description(\"%s\")", entity.getDescription());
    }
}

