/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.fragment;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import org.jetbrains.annotations.NotNull;

public class FieldSetterEmitter<T>
implements CodeEmitter<T> {
    protected final String methodName;

    public FieldSetterEmitter(String methodName) {
        this.methodName = methodName;
    }

    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull T argument) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder(".").append(this.methodName).append("(");
        try {
            CodeEmitter<T> codeEmitter = ValueEmitterFactory.emitterFor(argument);
            context.incIndentation();
            String argumentCode = codeEmitter.emitCode(context, argument);
            context.decIndentation();
            builder.append(argumentCode).append(")");
        }
        catch (CodeGenerationException e) {
            context.decIndentation();
            throw new CodeGenerationException("Cannot generate invocation of method " + this.methodName + ": " + e.getMessage());
        }
        return builder.toString();
    }
}

