/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.task.BaseNodeTask;
import com.atlassian.bamboo.specs.model.task.NodeunitTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeunitTask
extends BaseNodeTask<NodeunitTask, NodeunitTaskProperties> {
    public static final String DEFAULT_NODEUNIT_EXECUTABLE = InliningUtils.preventInlining((String)"node_modules/nodeunit/bin/nodeunit");
    public static final String DEFAULT_TEST_DIRECTORY = InliningUtils.preventInlining((String)"test/");
    public static final String DEFAULT_RESULTS_DIRECTORY = InliningUtils.preventInlining((String)"test-reports/");
    public static final boolean DEFAULT_PARSE_TEST_RESULTS = InliningUtils.preventInlining((boolean)true);
    @NotNull
    private String nodeunitExecutable = DEFAULT_NODEUNIT_EXECUTABLE;
    @NotNull
    private String testFilesAndDirectories = DEFAULT_TEST_DIRECTORY;
    @NotNull
    private String testResultsDirectory = DEFAULT_RESULTS_DIRECTORY;
    private boolean parseTestResults = DEFAULT_PARSE_TEST_RESULTS;
    @Nullable
    private String arguments;

    public NodeunitTask nodeunitExecutable(@NotNull String nodeunitExecutable) {
        ImporterUtils.checkNotNull((String)"nodeunitExecutable", (Object)nodeunitExecutable);
        this.nodeunitExecutable = nodeunitExecutable;
        return this;
    }

    public NodeunitTask testFilesAndDirectories(@NotNull String testFilesAndDirectories) {
        ImporterUtils.checkNotNull((String)"testFilesAndDirectories", (Object)testFilesAndDirectories);
        this.testFilesAndDirectories = testFilesAndDirectories;
        return this;
    }

    public NodeunitTask testResultsDirectory(@NotNull String testResultsDirectory) {
        ImporterUtils.checkNotNull((String)"testResultsDirectory", (Object)testResultsDirectory);
        this.testResultsDirectory = testResultsDirectory;
        return this;
    }

    public NodeunitTask parseTestResults(boolean parseTestResults) {
        this.parseTestResults = parseTestResults;
        return this;
    }

    public NodeunitTask arguments(@Nullable String arguments) {
        this.arguments = arguments;
        return this;
    }

    @NotNull
    protected NodeunitTaskProperties build() {
        return new NodeunitTaskProperties(this.description, this.taskEnabled, this.nodeExecutable, this.environmentVariables, this.workingSubdirectory, this.nodeunitExecutable, this.testFilesAndDirectories, this.testResultsDirectory, this.parseTestResults, this.arguments, this.requirements, this.conditions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeunitTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeunitTask that = (NodeunitTask)((Object)o);
        return this.parseTestResults == that.parseTestResults && this.nodeunitExecutable.equals(that.nodeunitExecutable) && this.testFilesAndDirectories.equals(that.testFilesAndDirectories) && this.testResultsDirectory.equals(that.testResultsDirectory) && Objects.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nodeunitExecutable, this.testFilesAndDirectories, this.testResultsDirectory, this.parseTestResults, this.arguments);
    }
}

