/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.permission;

import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.LoggedInUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PermissionValidator {
    private static final Map<PermissionTarget, Set<PermissionType>> ALLOWED_PERMISSIONS = new HashMap<PermissionTarget, Set<PermissionType>>();

    private PermissionValidator() {
    }

    public static List<ValidationProblem> validatePermissions(@NotNull PermissionsProperties permission, @NotNull PermissionTarget target) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        errors.addAll(PermissionValidator.validateGroupPermissions(permission.getGroupPermissions(), target));
        errors.addAll(PermissionValidator.validateUserPermissions(permission.getUserPermissions(), target));
        errors.addAll(PermissionValidator.validateLoggedInUserPermissions(permission.getLoggedInUserPermissions(), target));
        return errors;
    }

    private static List<ValidationProblem> validateLoggedInUserPermissions(LoggedInUserPermissionsProperties loggedInUserPermission, PermissionTarget target) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        for (PermissionType permissionType : loggedInUserPermission.getPermissionTypes()) {
            if (ALLOWED_PERMISSIONS.get((Object)target).contains((Object)permissionType)) continue;
            errors.add(new ValidationProblem(String.format("Cannot assign permission %s to logged in users as it's not applicable to %ss", new Object[]{permissionType, target.name().toLowerCase()})));
        }
        return errors;
    }

    private static List<ValidationProblem> validateUserPermissions(List<UserPermissionProperties> userPermissions, PermissionTarget target) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        for (UserPermissionProperties userPermissionProperties : userPermissions) {
            for (PermissionType permissionType : userPermissionProperties.getPermissionTypes()) {
                if (ALLOWED_PERMISSIONS.get((Object)target).contains((Object)permissionType)) continue;
                errors.add(new ValidationProblem(String.format("Cannot assign permission %s to user %s as it's not applicable to %ss", new Object[]{permissionType, userPermissionProperties.getUsername(), target.name().toLowerCase()})));
            }
        }
        return errors;
    }

    private static List<ValidationProblem> validateGroupPermissions(List<GroupPermissionProperties> groupPermissions, PermissionTarget target) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        for (GroupPermissionProperties groupPermissionProperties : groupPermissions) {
            for (PermissionType permissionType : groupPermissionProperties.getPermissionTypes()) {
                if (ALLOWED_PERMISSIONS.get((Object)target).contains((Object)permissionType)) continue;
                errors.add(new ValidationProblem(String.format("Cannot assign permission %s to group %s as it's not applicable to %ss", new Object[]{permissionType, groupPermissionProperties.getGroup(), target.name().toLowerCase()})));
            }
        }
        return errors;
    }

    static {
        ALLOWED_PERMISSIONS.put(PermissionTarget.PLAN, EnumSet.of(PermissionType.VIEW, new PermissionType[]{PermissionType.EDIT, PermissionType.BUILD, PermissionType.CLONE, PermissionType.ADMIN, PermissionType.VIEW_CONFIGURATION, PermissionType.CREATE_PLAN_BRANCH}));
        ALLOWED_PERMISSIONS.put(PermissionTarget.DEPLOYMENT, EnumSet.of(PermissionType.VIEW, new PermissionType[]{PermissionType.EDIT, PermissionType.VIEW_CONFIGURATION, PermissionType.APPROVE_RELEASE, PermissionType.CREATE_RELEASE, PermissionType.CLONE, PermissionType.ADMIN}));
        ALLOWED_PERMISSIONS.put(PermissionTarget.ENVIRONMENT, EnumSet.of(PermissionType.VIEW, PermissionType.EDIT, PermissionType.BUILD, PermissionType.VIEW_CONFIGURATION));
        ALLOWED_PERMISSIONS.put(PermissionTarget.PROJECT, EnumSet.of(PermissionType.VIEW, PermissionType.CREATE, PermissionType.CREATE_REPOSITORY, PermissionType.ADMIN));
    }

    public static enum PermissionTarget {
        PLAN,
        DEPLOYMENT,
        ENVIRONMENT,
        PROJECT;

    }
}

