/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.util;

import com.atlassian.bamboo.specs.api.builders.plan.configuration.AllOtherPluginsConfiguration;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.model.plan.configuration.AllOtherPluginsConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.util.MapUtils;
import java.util.Map;

public final class PluginConfigurationHelper {
    private PluginConfigurationHelper() {
    }

    public static void putPluginConfiguration(Map<String, PluginConfigurationProperties> pluginConfigurations, PluginConfiguration<?> pluginConfigurationToAdd) {
        PluginConfigurationProperties pluginConfigurationProperties = (PluginConfigurationProperties)EntityPropertiesBuilders.build(pluginConfigurationToAdd);
        if (!(pluginConfigurationToAdd instanceof AllOtherPluginsConfiguration) || !pluginConfigurations.containsKey(pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey())) {
            pluginConfigurations.put(pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey(), pluginConfigurationProperties);
            return;
        }
        PluginConfigurationHelper.mergeGenericPluginConfigurations(pluginConfigurations, pluginConfigurationProperties);
    }

    private static void mergeGenericPluginConfigurations(Map<String, PluginConfigurationProperties> pluginConfigurations, PluginConfigurationProperties pluginConfigurationToAdd) {
        AllOtherPluginsConfigurationProperties aopcp = (AllOtherPluginsConfigurationProperties)pluginConfigurations.get(pluginConfigurationToAdd.getAtlassianPlugin().getCompleteModuleKey());
        Map<String, Object> existingConfiguration = MapUtils.copyOf(aopcp.getConfiguration());
        PluginConfigurationHelper.mergeConfigurationMaps(((AllOtherPluginsConfigurationProperties)pluginConfigurationToAdd).getConfiguration(), existingConfiguration);
        pluginConfigurations.put(pluginConfigurationToAdd.getAtlassianPlugin().getCompleteModuleKey(), (PluginConfigurationProperties)EntityPropertiesBuilders.build(new AllOtherPluginsConfiguration().configuration(existingConfiguration)));
    }

    private static void mergeConfigurationMaps(Map<String, Object> newConfiguration, Map<String, Object> existingConfiguration) {
        newConfiguration.forEach((k, v) -> {
            if (v == null) {
                existingConfiguration.remove(k);
                existingConfiguration.keySet().removeIf(ek -> ek.startsWith(k + "."));
                return;
            }
            if (!(existingConfiguration.get(k) instanceof Map)) {
                existingConfiguration.put((String)k, v);
                return;
            }
            Map innerExistingMap = (Map)existingConfiguration.get(k);
            if (!(v instanceof Map)) {
                throw new IllegalStateException("Cannot merge map with value for key" + k);
            }
            Map innerNewMap = (Map)v;
            PluginConfigurationHelper.mergeConfigurationMaps(innerNewMap, innerExistingMap);
        });
    }
}

