/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.branches;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.PlanBranchIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.PlanBranchIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class BranchIntegration
extends EntityPropertiesBuilder<BranchIntegrationProperties> {
    private boolean enabled = true;
    private PlanBranchIdentifier integrationBranch;
    private boolean gatekeeper;
    private boolean pushOn;

    public BranchIntegration enabled(boolean enabled) throws PropertiesValidationException {
        this.enabled = enabled;
        return this;
    }

    public BranchIntegration integrationBranchOid(@NotNull String integrationBranchOid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("integrationBranchOid", integrationBranchOid);
        return this.integrationBranchOid(new BambooOid(integrationBranchOid));
    }

    public BranchIntegration integrationBranchOid(@NotNull BambooOid integrationBranchOid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("integrationBranchOid", integrationBranchOid);
        if (this.integrationBranch != null) {
            this.integrationBranch.oid(integrationBranchOid);
        } else {
            this.integrationBranch = new PlanBranchIdentifier(integrationBranchOid);
        }
        return this;
    }

    public BranchIntegration integrationBranchKey(@NotNull String integrationBranchKey) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("integrationBranchKey", integrationBranchKey);
        return this.integrationBranchKey(new BambooKey(integrationBranchKey));
    }

    public BranchIntegration integrationBranchKey(@NotNull BambooKey integrationBranchKey) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("integrationBranchKey", integrationBranchKey);
        if (this.integrationBranch != null) {
            this.integrationBranch.key(integrationBranchKey);
        } else {
            this.integrationBranch = new PlanBranchIdentifier(integrationBranchKey);
        }
        return this;
    }

    public BranchIntegration integrationBranch(@NotNull PlanBranchIdentifier integrationBranch) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("integrationBranch", integrationBranch);
        this.integrationBranch = new PlanBranchIdentifier(integrationBranch);
        return this;
    }

    public BranchIntegration gatekeeper(boolean gatekeeper) throws PropertiesValidationException {
        this.gatekeeper = gatekeeper;
        return this;
    }

    public BranchIntegration pushOnSuccessfulBuild(boolean push) throws PropertiesValidationException {
        this.pushOn = push;
        return this;
    }

    @Override
    protected BranchIntegrationProperties build() throws PropertiesValidationException {
        if (this.enabled && this.integrationBranch != null) {
            return new BranchIntegrationProperties(this.enabled, (PlanBranchIdentifierProperties)EntityPropertiesBuilders.build(this.integrationBranch), this.gatekeeper, this.pushOn);
        }
        return new BranchIntegrationProperties(this.enabled, null, this.gatekeeper, this.pushOn);
    }
}

