/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph.v25;

import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.integration.seraph.CrowdAuthenticator;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.ClientResourceLocator;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.seraph.auth.AuthenticationContextAwareAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.Lazy;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;
import org.apache.log4j.Logger;

@AuthenticationContextAwareAuthenticator
public class BambooAuthenticator
extends CrowdAuthenticator {
    private static final Logger log = Logger.getLogger(BambooAuthenticator.class);
    private Boolean isRecoveryModeOn;
    private com.atlassian.bamboo.user.authentication.BambooAuthenticator recoveryModeAuthenticator;
    private static final Supplier<CrowdHttpAuthenticator> crowdHttpAuthenticator = Lazy.supplier(() -> {
        String configDirectory = ((BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager")).getConfigDirectory();
        ClientResourceLocator clientResourceLocator = new ClientResourceLocator("crowd.properties", configDirectory);
        log.info((Object)("Reading crowd.properties from " + configDirectory));
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)clientResourceLocator);
        RestCrowdClientFactory clientFactory = new RestCrowdClientFactory();
        CrowdClient crowdClient = clientFactory.newInstance((ClientProperties)clientProperties);
        CrowdHttpTokenHelper tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
        return new CrowdHttpAuthenticatorImpl(crowdClient, (ClientProperties)clientProperties, tokenHelper);
    });
    private SecurityConfig config;
    private Map<String, String> params;

    public BambooAuthenticator() {
        super(BambooAuthenticator.newAuthenticator(), BambooAuthenticator::getCrowdService);
    }

    public void init(Map<String, String> params, SecurityConfig config) {
        super.init(params, config);
        this.params = params;
        this.config = config;
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        if (this.isRecoveryModeOn == null) {
            RecoveryModeService recoveryModeService = (RecoveryModeService)ComponentAccessor.CROWD_RECOVERY_MODE_SERVICE.get();
            this.isRecoveryModeOn = recoveryModeService.isRecoveryModeOn();
            if (this.isRecoveryModeOn.booleanValue()) {
                this.recoveryModeAuthenticator = new com.atlassian.bamboo.user.authentication.BambooAuthenticator();
                this.recoveryModeAuthenticator.init(this.params, this.config);
            } else {
                this.recoveryModeAuthenticator = null;
            }
        }
        if (this.isRecoveryModeOn.booleanValue()) {
            return this.recoveryModeAuthenticator.login(request, response, username, password, cookie);
        }
        return super.login(request, response, username, password, cookie);
    }

    private static CrowdService getCrowdService() {
        return (CrowdService)ContainerManager.getComponent((String)"crowdService");
    }

    protected Principal getUser(String username) {
        try {
            return BambooAuthenticator.getCrowdService().getUser(username);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        if (this.isRecoveryModeOn != null && this.isRecoveryModeOn.booleanValue()) {
            return this.recoveryModeAuthenticator.getUser(request, response);
        }
        return super.getUser(request, response);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        if (this.isRecoveryModeOn != null && this.isRecoveryModeOn.booleanValue()) {
            return this.recoveryModeAuthenticator.logout(request, response);
        }
        return super.logout(request, response);
    }

    private Authentication createAuthentication(ServletRequest request) {
        AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", new GrantedAuthority[]{Authority.ANONYMOUS});
        auth.setDetails(new AuthenticationDetailsSourceImpl().buildDetails((HttpServletRequest)request));
        return auth;
    }

    protected void logoutUser(HttpServletRequest request) {
        ImpersonationHelper.newAuthenticationForCurrentThread((Authentication)this.createAuthentication((ServletRequest)request));
    }

    private static CrowdHttpAuthenticator newAuthenticator() {
        return (CrowdHttpAuthenticator)Proxy.newProxyInstance(BambooAuthenticator.class.getClassLoader(), new Class[]{CrowdHttpAuthenticator.class}, (proxy, method, args) -> method.invoke((Object)crowdHttpAuthenticator.get(), args));
    }
}

