/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.user.Entity;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import java.util.ArrayList;
import java.util.List;

final class QueryRestrictionConverter {
    QueryRestrictionConverter() {
    }

    <T extends Entity> SearchRestriction toRestriction(Query<T> query) {
        if (query instanceof BooleanQuery) {
            return this.toBooleanRestriction((BooleanQuery)query);
        }
        assert (query instanceof TermQuery) : "There are only two basic types of queries: TermQuery and BooleanQuery";
        return QueryRestrictionConverter.toTermRestriction((TermQuery)query);
    }

    private <T extends Entity> SearchRestriction toBooleanRestriction(BooleanQuery<T> booleanQuery) {
        List nestedQueries = booleanQuery.getQueries();
        ArrayList<SearchRestriction> restrictions = new ArrayList<SearchRestriction>(nestedQueries.size());
        for (Query nestedQuery : nestedQueries) {
            restrictions.add(this.toRestriction(nestedQuery));
        }
        BooleanRestriction.BooleanLogic logic = booleanQuery.isAND() ? BooleanRestriction.BooleanLogic.AND : BooleanRestriction.BooleanLogic.OR;
        return new BooleanRestrictionImpl(logic, restrictions);
    }

    private static <T extends Entity> SearchRestriction toTermRestriction(TermQuery<T> termQuery) {
        return new TermRestriction(QueryRestrictionConverter.getTermQueryProperty(termQuery), QueryRestrictionConverter.getTermQueryMatchMode(termQuery), (Object)termQuery.getTerm());
    }

    private static <T extends Entity> MatchMode getTermQueryMatchMode(TermQuery<T> query) {
        String matchingRule = query.getMatchingRule();
        if ("starts_with".equals(matchingRule)) {
            return MatchMode.STARTS_WITH;
        }
        if ("ends_with".equals(matchingRule)) {
            return MatchMode.CONTAINS;
        }
        if ("contains".equals(matchingRule)) {
            return MatchMode.CONTAINS;
        }
        if ("*".equals(matchingRule)) {
            throw new IllegalArgumentException("Wildcard queries are not accepted by Crowd");
        }
        return MatchMode.EXACTLY_MATCHES;
    }

    private static <T extends Entity> Property<String> getTermQueryProperty(TermQuery<T> query) {
        if (query instanceof UserNameTermQuery) {
            return UserTermKeys.USERNAME;
        }
        if (query instanceof EmailTermQuery) {
            return UserTermKeys.EMAIL;
        }
        if (query instanceof FullNameTermQuery) {
            return UserTermKeys.DISPLAY_NAME;
        }
        if (query instanceof GroupNameTermQuery) {
            return GroupTermKeys.NAME;
        }
        throw new IllegalArgumentException("Unknown query type: " + String.valueOf(query));
    }
}

