/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.bamboo.cluster.state.Stateful;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.event.application.ApplicationDirectoryAddedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryRemovedEvent;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.user.User;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Stateful
public class MembershipCache {
    private static final Logger log = LogManager.getLogger(MembershipCache.class);
    private final Cache<User, List<String>> cache;
    private static final long CACHE_EXPIRY_AFTER_WRITE_SECONDS = new SystemProperty.IntegerSystemProperty(false, 900L, new String[]{"bamboo.cache.membership.expiry.seconds"}).getTypedValue();
    public static final String CACHE_NAME = "bamboo." + MembershipCache.class.getSimpleName() + ".cache";

    public MembershipCache(CacheManager cacheManager, CacheLoader<User, List<String>> loader) {
        this.cache = cacheManager.getCache(CACHE_NAME, loader, new CacheSettingsBuilder().expireAfterWrite(CACHE_EXPIRY_AFTER_WRITE_SECONDS, TimeUnit.SECONDS).build());
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipsCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipsDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupUpdatedEvent(GroupUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onUserEditedEvent(UserEditedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onUserDeletedEvent(UsersDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onDirectoryDeletedEvent(DirectoryDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onDirectoryUpdatedEvent(DirectoryUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onDirectoryCreatedEvent(DirectoryCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationDirectoryAddedEvent(ApplicationDirectoryAddedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationDirectoryRemovedEvent(ApplicationDirectoryRemovedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationDirectoryOrderUpdatedEvent(ApplicationDirectoryOrderUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationUpdatedEvent(ApplicationUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @Nullable
    public List<String> getGroupNamesAsList(User user) {
        return (List)this.cache.get((Object)user);
    }

    private void resetCache(Object event) {
        log.debug("Invalidating the entire cache after receiving event: {}", event);
        this.cache.removeAll();
    }
}

