/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.atlassianuser.Conversions;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUserManager;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.SecureRandomStringUtils;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.EntityMissingException;
import com.atlassian.user.impl.EntityValidationException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.Pagers;
import com.atlassian.user.security.authentication.InvalidPasswordException;
import com.atlassian.user.security.password.Credential;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EmbeddedCrowdUserManagerImpl
implements EmbeddedCrowdUserManager {
    private static final String DEFAULT_BLANK = "-";
    private static final int RANDOM_PASSWORD_LENGTH = 22;
    @Inject
    private RepositoryIdentifier repositoryIdentifier;
    @Inject
    private CrowdService crowdService;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    @Inject
    private PermissionManager permissionManager;

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) {
        if (this.getUser(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(Directory::isActive).anyMatch(d -> this.permissionManager.hasPermission(d, OperationType.CREATE_USER));
    }

    public Pager<com.atlassian.user.User> getUsers() {
        Iterable allUsers = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        return Pagers.newDefaultPager(Conversions.transform(allUsers, Conversions.TO_ATLASSIAN_USER));
    }

    public Pager<String> getUserNames() {
        Iterable usernames = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        return new DefaultPager((Collection)Lists.newArrayList(usernames.iterator()));
    }

    public com.atlassian.user.User getUser(String username) {
        Preconditions.checkNotNull((Object)username, (Object)"username must not be null.");
        return Conversions.TO_ATLASSIAN_USER.apply(this.crowdService.getUser(username));
    }

    public com.atlassian.user.User createUser(String username) throws EntityException {
        DefaultUser userTemplate = new DefaultUser(username, DEFAULT_BLANK, DEFAULT_BLANK);
        return this.createUser((com.atlassian.user.User)userTemplate, Credential.NONE);
    }

    public com.atlassian.user.User createUser(com.atlassian.user.User userTemplate, Credential credential) throws EntityException, IllegalArgumentException {
        User crowdUser;
        com.atlassian.user.User existingUser = this.getUser(userTemplate.getName());
        if (existingUser != null) {
            throw new DuplicateEntityException("User with name [" + userTemplate.getName() + "] already exists in this repository (" + this.getIdentifier().getName() + ")");
        }
        if (Credential.NONE.equals((Object)credential)) {
            credential = this.createRandomCredential();
        }
        if (credential.isEncrypted()) {
            throw new IllegalArgumentException("Cannot create a user with an already encrypted credential");
        }
        try {
            crowdUser = this.crowdService.addUser((User)this.toEcUserTemplate(userTemplate), credential.getValue());
        }
        catch (InvalidUserException e) {
            throw new EntityValidationException((Throwable)e);
        }
        catch (InvalidCredentialException e) {
            throw new InvalidPasswordException((Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
        return Conversions.TO_ATLASSIAN_USER.apply(crowdUser);
    }

    private Credential createRandomCredential() {
        String randomPassword = SecureRandomStringUtils.getInstance().randomAlphanumericString(22);
        return Credential.unencrypted((String)randomPassword);
    }

    private UserTemplate toEcUserTemplate(com.atlassian.user.User atlassianUser) {
        UserTemplate template = new UserTemplate(atlassianUser.getName());
        template.setDisplayName(atlassianUser.getFullName());
        template.setEmailAddress(atlassianUser.getEmail());
        template.setActive(atlassianUser.isEnabled());
        return template;
    }

    public void alterPassword(com.atlassian.user.User user, String password) throws EntityException {
        try {
            this.crowdService.updateUserCredential(this.getCrowdUser(user), password);
        }
        catch (UserNotFoundException e) {
            throw new EntityMissingException((Throwable)e);
        }
        catch (InvalidCredentialException e) {
            throw new InvalidPasswordException((Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
    }

    public com.atlassian.user.User saveUser(com.atlassian.user.User user) throws EntityException, IllegalArgumentException {
        try {
            return Conversions.TO_ATLASSIAN_USER.apply(this.crowdService.updateUser((User)this.toEcUserTemplate(user)));
        }
        catch (InvalidUserException e) {
            throw new EntityException((Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void removeUser(com.atlassian.user.User user) throws EntityException, IllegalArgumentException {
        try {
            User crowdUser = this.getCrowdUser(user);
            if (crowdUser == null) {
                throw new IllegalArgumentException("User [" + user.getName() + "] is not managed by embedded crowd");
            }
            this.crowdService.removeUser(crowdUser);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
    }

    private User getCrowdUser(com.atlassian.user.User user) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)user, (Object)"User should not be null");
        if (user instanceof com.atlassian.crowd.model.user.User) {
            return (com.atlassian.crowd.model.user.User)user;
        }
        return this.crowdService.getUser(user.getName());
    }

    public boolean isReadOnly(com.atlassian.user.User user) {
        User crowdUser = this.getCrowdUser(user);
        if (crowdUser == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(crowdUser.getDirectoryId());
        Set allowedOperations = directory.getAllowedOperations();
        return !allowedOperations.contains(OperationType.CREATE_USER);
    }

    public com.atlassian.user.User renameUser(com.atlassian.user.User user, String newUsername) throws EntityException {
        try {
            return Conversions.TO_ATLASSIAN_USER.apply(this.crowdService.renameUser(this.getCrowdUser(user), newUsername));
        }
        catch (InvalidUserException | OperationNotPermittedException e) {
            throw new EntityException(e);
        }
    }

    public com.atlassian.user.User onExternalUserRename(String oldName, String newName) {
        return this.getUser(newName);
    }
}

