/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import bucket.user.BucketHibernateConfigProvider;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.user.Entity;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.impl.hibernate3.ExternalEntityDAO;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.hibernate5.HibernateConfigurationProvider;
import java.util.HashMap;
import javax.inject.Inject;
import org.springframework.context.annotation.Lazy;

public class EmbeddedCrowdPropertySetFactory
implements PropertySetFactory {
    private static final String HIBERNATE_PROPERTY_SET = "hibernate";
    private static final String PROPERTY_PREFIX = "CWD_";
    @Inject
    private CrowdService crowdService;
    @Lazy
    @Inject
    private ExternalEntityDAO externalEntityDAO;
    private final HibernateConfigurationProvider configProvider = new BucketHibernateConfigProvider();

    public PropertySet getPropertySet(Entity entity) {
        return this.getPropertySet(entity.getName());
    }

    protected PropertySet getPropertySet(String entityName) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        User user = this.crowdService.getUser(entityName);
        if (user != null) {
            args.put("entityId", 0L);
            args.put("entityName", PROPERTY_PREFIX + user.getName());
            args.put("configurationProvider", this.configProvider);
        } else {
            ExternalEntity externalEntity = this.externalEntityDAO.getExternalEntity(entityName);
            if (externalEntity == null) {
                externalEntity = this.externalEntityDAO.createExternalEntity(entityName);
            }
            args.put("entityId", externalEntity.getId());
            args.put("entityName", externalEntity.getType() + "_" + externalEntity.getName());
            args.put("configurationProvider", this.configProvider);
        }
        return PropertySetManager.getInstance((String)HIBERNATE_PROPERTY_SET, args);
    }
}

