/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.authentication;

import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.crowd.exception.runtime.CommunicationException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.plugin.util.ClassLoaderStack;
import com.atlassian.seraph.auth.AuthenticationContextAwareAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Stopwatch;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@AuthenticationContextAwareAuthenticator
public class BambooAuthenticator
extends DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(BambooAuthenticator.class);

    public boolean login(HttpServletRequest request, HttpServletResponse response, @Nullable String username, String password, boolean cookie) throws AuthenticatorException {
        if (username == null || !ContainerManager.isContainerSetup()) {
            return false;
        }
        Stopwatch started = Stopwatch.createStarted();
        try {
            boolean isAuthenticated = super.login(request, response, username, password, cookie);
            if (!isAuthenticated && log.isDebugEnabled()) {
                String ipAddress = request.getHeader("X-FORWARDED-FOR");
                if (ipAddress == null) {
                    ipAddress = request.getRemoteAddr();
                    log.debug((Object)("User '" + username + "' with IP address: " + ipAddress + " failed to log in."));
                } else {
                    log.debug((Object)("User '" + username + "' with IP address: " + ipAddress + ", " + request.getRemoteAddr() + " failed to log in."));
                }
            }
            boolean bl = isAuthenticated;
            return bl;
        }
        catch (CommunicationException e) {
            log.error((Object)"User repository communication failed: ", (Throwable)e);
            throw new AuthenticatorException("User repository communication failed");
        }
        catch (CrowdRuntimeException e) {
            log.error((Object)"Authentication failed due to embedded crowd error: ", (Throwable)e);
            throw new AuthenticatorException("Authentication failed due to embedded crowd error");
        }
        finally {
            BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)started, (int)1, (int)3, (int)9, (String)("Authentication checks for " + username));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean authenticate(Principal user, String password) {
        ClassLoaderStack.push((ClassLoader)BambooAuthenticator.class.getClassLoader());
        try {
            BambooUserManager bambooUserManager = (BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get();
            boolean bl = bambooUserManager.authenticate(user.getName(), password);
            return bl;
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    protected Principal getUser(String uid) {
        return ((BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get()).getUser(uid);
    }
}

