/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.xml;

import com.atlassian.bamboo.util.BambooUnicodeUtils;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.XMLReader;

public class BambooXmlUtils {
    private BambooXmlUtils() {
    }

    public static SAXReader newSecureSaxReader() {
        return new SAXReader(SecureXmlParserFactory.newXmlReader());
    }

    public static DocumentBuilderFactory newSecureDocumentBuilderFactory(@Nullable Logger log) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        BambooXmlUtils.setFeature(log, dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        BambooXmlUtils.setFeature(log, dbf, "http://xml.org/sax/features/external-general-entities", false);
        BambooXmlUtils.setFeature(log, dbf, "http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    public static XMLInputFactory newSecureXmlInputFactory() {
        return BambooXmlUtils.configure(XMLInputFactory.newInstance());
    }

    public static XMLInputFactory configure(XMLInputFactory xmlInputFactory) {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlInputFactory;
    }

    public static Digester newSecureDigester() {
        XMLReader reader = SecureXmlParserFactory.newXmlReader();
        Digester digester = new Digester(reader);
        digester.setEntityResolver(reader.getEntityResolver());
        return digester;
    }

    @Deprecated
    public static XMLReader newSecureXmlReader() {
        return SecureXmlParserFactory.newXmlReader();
    }

    private static void setFeature(@Nullable Logger log, DocumentBuilderFactory dbf, String name, boolean value) {
        try {
            dbf.setFeature(name, value);
        }
        catch (ParserConfigurationException e) {
            if (log != null) {
                log.warn((Object)("Unable to set " + name + " to " + value));
            }
            throw new UnsupportedOperationException(e);
        }
    }

    @NotNull
    public static String sanitiseXml10(@NotNull String value) {
        int codePoint;
        int len = value.length();
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            if (BambooUnicodeUtils.validXml10((int)codePoint)) continue;
            return BambooXmlUtils.sanitiseFrom(value, i, codePoint);
        }
        return value;
    }

    @NotNull
    public static Reader sanitiseXml10Reader(@NotNull Reader in) {
        final PushbackReader pushbackReader = new PushbackReader(new BufferedReader(in));
        return new FilterReader(pushbackReader){
            int nextWithoutFiltering;
            {
                super(in);
                this.nextWithoutFiltering = -1;
            }

            private int readCodePoint() throws IOException {
                int firstChar = pushbackReader.read();
                if (firstChar < 0 || !Character.isHighSurrogate((char)firstChar)) {
                    return firstChar;
                }
                int secondChar = pushbackReader.read();
                if (secondChar == -1) {
                    return firstChar;
                }
                if (!Character.isLowSurrogate((char)secondChar)) {
                    pushbackReader.unread(secondChar);
                    return firstChar;
                }
                return Character.toCodePoint((char)firstChar, (char)secondChar);
            }

            @Override
            public int read() throws IOException {
                int codePoint;
                do {
                    if (this.nextWithoutFiltering != -1) {
                        int c = this.nextWithoutFiltering;
                        this.nextWithoutFiltering = -1;
                        return c;
                    }
                    codePoint = this.readCodePoint();
                    if (codePoint != -1) continue;
                    return -1;
                } while (!BambooUnicodeUtils.validXml10((int)codePoint));
                if (Character.charCount(codePoint) == 2) {
                    char[] pair = Character.toChars(codePoint);
                    this.nextWithoutFiltering = pair[1];
                    return pair[0];
                }
                return codePoint;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    int c = this.read();
                    if (c == -1) {
                        if (i == 0) {
                            return -1;
                        }
                        return i;
                    }
                    cbuf[off + i] = (char)c;
                }
                return len;
            }
        };
    }

    @NotNull
    private static String sanitiseFrom(@NotNull String value, int firstInvalidChar, int invalidCodePoint) {
        int codePoint;
        StringBuilder sb = new StringBuilder(value.substring(0, firstInvalidChar));
        int len = value.length();
        for (int i = firstInvalidChar + Character.charCount(invalidCodePoint); i < len; i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            if (!BambooUnicodeUtils.validXml10((int)codePoint)) continue;
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }
}

