/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.xstream.converters;

import com.atlassian.bamboo.utils.xstream.converters.ConverterFactory;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.jetbrains.annotations.NotNull;

public class DefaultConverterFactory
implements ConverterFactory {
    private final Class<? extends Converter> targetClass;
    private final InstantiationStrategy instantiationStrategy;

    public DefaultConverterFactory(@NotNull Class<? extends Converter> targetClass) {
        this(targetClass, InstantiationStrategy.DEFAULT);
    }

    public DefaultConverterFactory(@NotNull Class<? extends Converter> targetClass, @NotNull InstantiationStrategy instantiationStrategy) {
        this.targetClass = targetClass;
        this.instantiationStrategy = instantiationStrategy;
    }

    @Override
    @NotNull
    public Converter createConverter(@NotNull XStream xStream) {
        try {
            return this.instantiationStrategy.newInstance(this.targetClass, xStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class '" + this.targetClass.getName() + "' using strategy '" + String.valueOf((Object)this.instantiationStrategy) + "'", e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum InstantiationStrategy {
        USING_XSTREAM{

            @Override
            <T extends Converter> T newInstance(Class<T> converterClass, XStream xStream) throws Exception {
                return (T)((Converter)converterClass.getConstructor(XStream.class).newInstance(xStream));
            }
        }
        ,
        USING_MAPPER{

            @Override
            <T extends Converter> T newInstance(Class<T> converterClass, XStream xStream) throws Exception {
                return (T)((Converter)converterClass.getConstructor(Mapper.class).newInstance(xStream.getMapper()));
            }
        };

        static final InstantiationStrategy DEFAULT;

        abstract <T extends Converter> T newInstance(Class<T> var1, XStream var2) throws Exception;

        static {
            DEFAULT = USING_MAPPER;
        }
    }
}

