/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.scopedcaches;

import com.atlassian.bamboo.utils.scopedcaches.ScopedCaches;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ThreadScopedCaches {
    private static final ThreadLocal<ScopedCaches> PER_THREAD_CACHE = ThreadLocal.withInitial(ScopedCaches::new);

    @Nullable
    private static <K, V> Map<K, V> getCache(Key<K, V> cacheKey) {
        ScopedCaches threadScopedCaches = ThreadScopedCaches.getThreadScopedCaches();
        return threadScopedCaches.isInCachingScope() ? threadScopedCaches.getCache(cacheKey) : null;
    }

    public static <K, V> V getValue(Key<K, V> cacheKey, K key, Supplier<? extends V> supplier) {
        Map<K, V> cache = ThreadScopedCaches.getCache(cacheKey);
        if (cache == null) {
            return supplier.get();
        }
        V value = cache.get(key);
        if (value == null) {
            value = supplier.get();
            cache.put(key, value);
        }
        return value;
    }

    public static void inCachingScope(Runnable runnable) {
        ThreadScopedCaches.enterCachingScope();
        try {
            runnable.run();
        }
        finally {
            ThreadScopedCaches.leaveCachingScope();
        }
    }

    public static <T> T inCachingScope(Supplier<T> supplier) {
        ThreadScopedCaches.enterCachingScope();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            ThreadScopedCaches.leaveCachingScope();
        }
    }

    static int leaveCachingScope() {
        return ThreadScopedCaches.getThreadScopedCaches().leaveCachingScope();
    }

    static void enterCachingScope() {
        ThreadScopedCaches.getThreadScopedCaches().enterCachingScope();
    }

    public static <K, V> Key<K, V> makeKey(final Class<?> aClass) {
        return new Key<K, V>(){
            final Class<?> source;
            {
                this.source = aClass;
            }
        };
    }

    private static ScopedCaches getThreadScopedCaches() {
        return PER_THREAD_CACHE.get();
    }

    @VisibleForTesting
    static boolean isInCachedScope() {
        return ThreadScopedCaches.getThreadScopedCaches().isInCachingScope();
    }

    public static interface Key<K, V> {
    }
}

