/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.files;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class MoreFiles {
    @NotNull
    public static Path resolve(@NotNull Path path, @NotNull String first, String ... more) {
        return Objects.requireNonNull(path, "path").resolve(Paths.get(first, more));
    }

    @NotNull
    public static Path mkdir(@NotNull Path parent, @NotNull String child) {
        Objects.requireNonNull(parent, "parent");
        if (Objects.requireNonNull(child, "child").trim().isEmpty()) {
            throw new IllegalArgumentException("A path for the created directory is required");
        }
        return MoreFiles.mkdir(parent.resolve(child));
    }

    @NotNull
    public static Path mkdir(@NotNull Path directory) {
        Objects.requireNonNull(directory, "directory");
        try {
            return Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException && Files.isDirectory(directory, new LinkOption[0])) {
                return directory;
            }
            throw new IllegalStateException("Could not create " + String.valueOf(directory.toAbsolutePath()), e);
        }
    }

    public static boolean isWithin(@NotNull Path path, @NotNull Path expectedParent) throws IOException {
        Path test;
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(expectedParent, "expectedParent");
        if (!Files.isDirectory(expectedParent, new LinkOption[0])) {
            throw new IllegalArgumentException("expectedParent is not a directory");
        }
        try {
            test = path.toRealPath(new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            test = Paths.get(path.toFile().getCanonicalPath(), new String[0]);
        }
        return test.startsWith(expectedParent.toRealPath(new LinkOption[0]));
    }

    public static long getLastModified(@NotNull Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException _ignored) {
            return 0L;
        }
    }

    public static void cleanDirectory(@NotNull Path directory) throws IOException {
        Objects.requireNonNull(directory, "directory");
        try (Stream<Path> entries = Files.list(directory);){
            for (Path entry : entries::iterator) {
                BasicFileAttributes attributes = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.isDirectory()) {
                    MoreFiles.deleteRecursively(entry);
                    continue;
                }
                Files.delete(entry);
            }
        }
    }

    public static void deleteRecursively(@NotNull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.maybeClearReadOnly(dir, attrs);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return this.deleteIfExists(dir);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                this.maybeClearReadOnly(file, attrs);
                return this.deleteIfExists(file);
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof FileNotFoundException || exc instanceof NoSuchFileException) {
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }

            private FileVisitResult deleteIfExists(Path path) throws IOException {
                try {
                    Files.delete(path);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            private void maybeClearReadOnly(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs instanceof DosFileAttributes && ((DosFileAttributes)attrs).isReadOnly()) {
                    Files.getFileAttributeView(file, DosFileAttributeView.class, new LinkOption[0]).setReadOnly(false);
                }
            }
        });
    }

    public static long size(@NotNull Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static void deleteOnExit(@NotNull Path path) {
        Objects.requireNonNull(path, "path").toFile().deleteOnExit();
    }

    public static void touch(@NotNull Path path) throws IOException {
        try {
            Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }
}

