/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.files;

import com.atlassian.bamboo.utils.BambooFiles;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DeleteIfNotWhiteListedFilVisitor
implements FileVisitor<Path> {
    private final Set<Path> whiteListedPaths;
    private final Optional<Logger> logger;

    public DeleteIfNotWhiteListedFilVisitor(Set<Path> whiteListedPaths, Optional<Logger> logger) {
        this.whiteListedPaths = whiteListedPaths;
        this.logger = logger;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!this.whiteListedPaths.contains(file)) {
            String stringifiedPath = file.toString();
            BambooFiles.delete(file);
            this.logger.ifPresent(l -> l.debug("Removed file: {}", (Object)stringifiedPath));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }
}

