/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.HtmlUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class UrlUtils {
    private static final String SCHEME_DELIMITER = "://";
    private static final Predicate<String> URL_HAS_VALID_SCHEME = url -> Stream.of("http", "https").map(scheme -> scheme + ":").anyMatch(scheme -> StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)scheme));
    private static final Predicate<String> CONTAINS_COLON = url -> StringUtils.contains((CharSequence)url, (CharSequence)":") || StringUtils.containsIgnoreCase((CharSequence)url, (CharSequence)"&colon;");

    public static boolean isSafeUrl(String returnUrl) {
        List urlsToConsider = Stream.of(returnUrl, StringEscapeUtils.unescapeHtml4((String)returnUrl), HtmlUtils.stripHtml(returnUrl)).map(StringUtils::trimToEmpty).distinct().collect(Collectors.toList());
        return urlsToConsider.stream().anyMatch(URL_HAS_VALID_SCHEME) || urlsToConsider.stream().noneMatch(CONTAINS_COLON);
    }

    public static String getPathUnderContext(@NotNull String url, @NotNull String context) {
        String path;
        int pathStart;
        if (url.startsWith("/")) {
            return StringUtils.removeStart((String)url, (String)context);
        }
        int urlSchemeEnd = url.indexOf(SCHEME_DELIMITER);
        if (urlSchemeEnd > 0) {
            urlSchemeEnd += SCHEME_DELIMITER.length();
        }
        int n = pathStart = urlSchemeEnd > 0 ? url.indexOf(47, urlSchemeEnd) : 0;
        if (pathStart > 0 && (path = url.substring(pathStart)).startsWith(context)) {
            return StringUtils.removeStart((String)path, (String)context);
        }
        return url;
    }
}

