/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.InvocationLimiterResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class InvocationLimiter<T> {
    private static final Logger log = LogManager.getLogger(InvocationLimiter.class);
    private final ReentrantReadWriteLock anyReadInProgress = new ReentrantReadWriteLock();
    private BiFunction<Integer, TimeUnit, LoadingCache<T, TimeAwareCounter>> cacheProvider;
    private LoadingCache<T, TimeAwareCounter> cache;
    private int invocationLimit;
    private Duration invocationLimitPeriod;
    private Ticker ticker = Ticker.systemTicker();

    public InvocationLimiter(int invocationLimit, int invocationLimitUnitCount, @NotNull TimeUnit invocationLimitUnit) {
        this.cacheProvider = (duration, unit) -> CacheBuilder.newBuilder().expireAfterWrite((long)duration.intValue(), unit).ticker(this.ticker).build(CacheLoader.from(key -> new TimeAwareCounter(this.ticker.read())));
        this.resetSettings(invocationLimit, invocationLimitUnitCount, invocationLimitUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <V> InvocationLimiterResponse<V> invoke(@NotNull T resource, @NotNull Supplier<V> invocation) {
        this.anyReadInProgress.readLock().lock();
        Duration retryAfter = Duration.ZERO;
        try {
            TimeAwareCounter timeAwareCounter = (TimeAwareCounter)this.cache.get(resource);
            int currentInvocationCount = timeAwareCounter.incrementAndGet();
            if (currentInvocationCount <= this.invocationLimit) {
                InvocationLimiterResponse<V> invocationLimiterResponse = InvocationLimiterResponse.successful(invocation.get());
                return invocationLimiterResponse;
            }
            long delta = this.ticker.read() - timeAwareCounter.getFirstWriteTime();
            retryAfter = Duration.ofNanos(this.invocationLimitPeriod.toNanos() - delta);
        }
        catch (ExecutionException e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.anyReadInProgress.readLock().unlock();
        }
        return InvocationLimiterResponse.rejected(retryAfter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSettings(int limit, int invocationLimitUnitCount, @NotNull TimeUnit invocationLimitUnit) {
        this.anyReadInProgress.writeLock().lock();
        try {
            this.cache = this.cacheProvider.apply(invocationLimitUnitCount, invocationLimitUnit);
            this.invocationLimit = limit;
            this.invocationLimitPeriod = Duration.ofNanos(invocationLimitUnit.toNanos(invocationLimitUnitCount));
        }
        finally {
            this.anyReadInProgress.writeLock().unlock();
        }
    }

    @VisibleForTesting
    void setTicker(@NotNull Ticker ticker) {
        this.ticker = ticker;
    }

    @VisibleForTesting
    void setCacheProvider(@NotNull BiFunction<Integer, TimeUnit, LoadingCache<T, TimeAwareCounter>> cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    @ThreadSafe
    static class TimeAwareCounter {
        private final long firstWriteTime;
        private final AtomicInteger counter = new AtomicInteger(0);

        public TimeAwareCounter(long firstWriteTime) {
            this.firstWriteTime = firstWriteTime;
        }

        public long getFirstWriteTime() {
            return this.firstWriteTime;
        }

        public int incrementAndGet() {
            return this.counter.incrementAndGet();
        }
    }
}

