/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.NotNull;

public class BambooSuppliers {
    @NotNull
    public static <T> java.util.function.Supplier<T> memoizeWithFixedTtl(@NotNull java.util.function.Supplier<T> supplier, @NotNull Duration ttl) {
        long ttlNanos = ttl.toNanos();
        Preconditions.checkArgument((ttlNanos > 0L ? 1 : 0) != 0);
        return new LazilyExpiringMemoizingSupplier<T>(supplier, ignored -> ttlNanos);
    }

    @NotNull
    public static <T> java.util.function.Supplier<T> memoizeWithAdaptiveTtl(java.util.function.Supplier<T> supplier, Duration minTtl, Duration maxTtl) {
        long minTtlNanos = minTtl.toNanos();
        Preconditions.checkArgument((minTtlNanos > 0L ? 1 : 0) != 0);
        long maxTtlNanos = maxTtl.toNanos();
        Preconditions.checkArgument((maxTtlNanos > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((minTtlNanos <= maxTtlNanos ? 1 : 0) != 0);
        return new LazilyExpiringMemoizingSupplier<T>(supplier, elapsed -> {
            if (elapsed >= maxTtlNanos) {
                return maxTtlNanos;
            }
            if (elapsed <= minTtlNanos) {
                return minTtlNanos;
            }
            return elapsed;
        });
    }

    public static <E> ResettableMemoizingSupplier<E> memoizeResettably(Supplier<E> supplier) {
        return new ResettableMemoizingSupplier<E>(supplier);
    }

    private static class LazilyExpiringMemoizingSupplier<T>
    implements java.util.function.Supplier<T> {
        private final java.util.function.Supplier<T> supplier;
        private final LongUnaryOperator ttlCalculator;
        private volatile transient T value;
        private volatile transient long expirationTime;

        LazilyExpiringMemoizingSupplier(java.util.function.Supplier<T> supplier, LongUnaryOperator ttlCalculator) {
            this.supplier = Objects.requireNonNull(supplier);
            this.ttlCalculator = ttlCalculator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            long expirationTimeWhenMethodWasCalled = this.expirationTime;
            if (expirationTimeWhenMethodWasCalled == 0L || System.nanoTime() - expirationTimeWhenMethodWasCalled >= 0L) {
                LazilyExpiringMemoizingSupplier lazilyExpiringMemoizingSupplier = this;
                synchronized (lazilyExpiringMemoizingSupplier) {
                    if (expirationTimeWhenMethodWasCalled != this.expirationTime) {
                        return this.value;
                    }
                    long calculationStarted = System.nanoTime();
                    T calculated = this.supplier.get();
                    this.value = calculated;
                    long now = System.nanoTime();
                    long newExpirationTime = now + this.ttlCalculator.applyAsLong(now - calculationStarted);
                    this.expirationTime = newExpirationTime == 0L ? 1L : newExpirationTime;
                    return calculated;
                }
            }
            return this.value;
        }
    }

    public static final class ResettableMemoizingSupplier<T>
    implements Serializable,
    Supplier<T> {
        private final Supplier<T> supplier;
        private volatile transient Supplier<T> memoized;

        private ResettableMemoizingSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
            this.memoized = Suppliers.memoize(supplier);
        }

        public T get() {
            return (T)this.memoized.get();
        }

        public void reset() {
            this.memoized = Suppliers.memoize(this.supplier);
        }
    }
}

