/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Deprecated
public final class BambooLogUtils {
    private static final String FORMAT = "Bamboo operation time: %s took %s ms";

    private BambooLogUtils() {
    }

    private static Priority getLogLevel(long elapsedTime, long infoThreshold, long warnThreshold, long errorThreshold) {
        if (elapsedTime < infoThreshold) {
            return Level.DEBUG;
        }
        if (elapsedTime < warnThreshold) {
            return Level.INFO;
        }
        if (elapsedTime < errorThreshold) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    public static Priority getLogLevel(Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds) {
        return BambooLogUtils.getLogLevel(stopWatch.elapsed(TimeUnit.SECONDS), (long)infoThresholdSeconds, (long)warnThresholdSeconds, (long)errorThresholdSeconds);
    }

    public static Priority getLogLevel(Stopwatch stopWatch, Duration infoThreshold, Duration warnThreshold, Duration errorThreshold) {
        return BambooLogUtils.getLogLevel(stopWatch.elapsed(TimeUnit.MILLISECONDS), infoThreshold.toMillis(), warnThreshold.toMillis(), errorThreshold.toMillis());
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds, String operation) {
        Priority priority = BambooLogUtils.getLogLevel(stopWatch, infoThresholdSeconds, warnThresholdSeconds, errorThresholdSeconds);
        log.log(priority, (Object)String.format(FORMAT, operation, stopWatch.elapsed(TimeUnit.MILLISECONDS)));
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, Duration infoThreshold, Duration warnThreshold, Duration errorThreshold, String operation) {
        Priority priority = BambooLogUtils.getLogLevel(stopWatch, infoThreshold, warnThreshold, errorThreshold);
        log.log(priority, (Object)String.format(FORMAT, operation, stopWatch.elapsed(TimeUnit.MILLISECONDS)));
    }
}

