/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class BambooLog4j2Utils {
    private static final String FORMAT = "Bamboo operation time: {} took {} ms";

    private BambooLog4j2Utils() {
    }

    private static Level getLogLevel(long elapsedTime, long infoThreshold, long warnThreshold, long errorThreshold) {
        if (elapsedTime < infoThreshold) {
            return Level.DEBUG;
        }
        if (elapsedTime < warnThreshold) {
            return Level.INFO;
        }
        if (elapsedTime < errorThreshold) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    public static Level getLogLevel(Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds) {
        return BambooLog4j2Utils.getLogLevel(stopWatch.elapsed(TimeUnit.SECONDS), (long)infoThresholdSeconds, (long)warnThresholdSeconds, (long)errorThresholdSeconds);
    }

    public static Level getLogLevel(Stopwatch stopWatch, Duration infoThreshold, Duration warnThreshold, Duration errorThreshold) {
        return BambooLog4j2Utils.getLogLevel(stopWatch.elapsed(TimeUnit.MILLISECONDS), infoThreshold.toMillis(), warnThreshold.toMillis(), errorThreshold.toMillis());
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds, Supplier<String> operation) {
        Level priority = BambooLog4j2Utils.getLogLevel(stopWatch, infoThresholdSeconds, warnThresholdSeconds, errorThresholdSeconds);
        if (log.isEnabled(priority)) {
            String opString = operation.get();
            log.log(priority, FORMAT, (Object)opString, (Object)stopWatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds, String operation) {
        Level priority = BambooLog4j2Utils.getLogLevel(stopWatch, infoThresholdSeconds, warnThresholdSeconds, errorThresholdSeconds);
        log.log(priority, FORMAT, (Object)operation, (Object)stopWatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, Duration infoThreshold, Duration warnThreshold, Duration errorThreshold, Supplier<String> operation) {
        Level priority = BambooLog4j2Utils.getLogLevel(stopWatch, infoThreshold, warnThreshold, errorThreshold);
        if (log.isEnabled(priority)) {
            String opString = operation.get();
            log.log(priority, FORMAT, (Object)opString, (Object)stopWatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, Duration infoThreshold, Duration warnThreshold, Duration errorThreshold, String operation) {
        Level priority = BambooLog4j2Utils.getLogLevel(stopWatch, infoThreshold, warnThreshold, errorThreshold);
        log.log(priority, FORMAT, (Object)operation, (Object)stopWatch.elapsed(TimeUnit.MILLISECONDS));
    }
}

