/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.BambooFileAttributes;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooFiles {
    public static final Logger log = Logger.getLogger(BambooFiles.class);

    public static boolean deleteQuietly(Path path) {
        try {
            BambooFiles.delete(path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void delete(Path path) throws IOException {
        Stopwatch stopWatch;
        block9: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attempting to delete file:" + String.valueOf(path)));
            }
            if (path == null) {
                return;
            }
            stopWatch = Stopwatch.createStarted();
            try {
                boolean delete = path.toFile().delete();
                if (!delete) {
                    Files.delete(path);
                }
            }
            catch (SecurityException e) {
                boolean delete;
                DosFileAttributeView fileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
                if (fileAttributeView == null) {
                    throw e;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Attempting to remove read-only status from file: " + String.valueOf(path)));
                }
                BambooFiles.unsetReadOnly(fileAttributeView, e);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Read-only status from file: " + String.valueOf(path) + " removed."));
                }
                if (delete = path.toFile().delete()) break block9;
                Files.delete(path);
            }
        }
        BambooLogUtils.logOperationTime(log, stopWatch, 3, 10, 30, "Deleting file " + String.valueOf(path));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully deleted: " + String.valueOf(path)));
        }
    }

    public static void deleteLogIfError(Path path, Logger logger) {
        try {
            BambooFiles.delete(path);
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
    }

    private static void unsetReadOnly(DosFileAttributeView fileAttributeView, SecurityException ade) {
        try {
            fileAttributeView.setReadOnly(false);
        }
        catch (IOException ignored) {
            throw ade;
        }
    }

    public static boolean isExecutable(Path path) throws IOException {
        BambooFileAttributes.ExecutablePermissionGetter getter = new BambooFileAttributes.ExecutablePermissionGetter();
        getter.accept(path);
        Boolean executable = getter.isExecutable();
        if (executable == null) {
            throw new UnsupportedOperationException("Don't know how to handle attributes for " + String.valueOf(path.getFileSystem().provider().getClass()));
        }
        return executable;
    }

    public static AutoRemoved autoRemoved(final Path path) {
        return new AutoRemoved(){

            @Override
            public void close() throws IOException {
                BambooPathUtils.forceDelete(path);
            }

            @Override
            public Path getPath() {
                return path;
            }
        };
    }

    public static QuietlyRemoved quietlyRemoved(final Path path) {
        return new QuietlyRemoved(){

            @Override
            public void close() {
                BambooPathUtils.deleteQuietly(path);
            }

            @Override
            public Path getPath() {
                return path;
            }

            public String toString() {
                return this.getPath().toString();
            }
        };
    }

    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        try {
            return Files.createTempDirectory(dir, prefix, attrs);
        }
        catch (NoSuchFileException ignored) {
            Files.createDirectories(dir, attrs);
            return Files.createTempDirectory(dir, prefix, attrs);
        }
    }

    public static void setReadOnly(Path path, boolean isReadOnly) throws IOException {
        BambooFileAttributes.FileAttributeVisitor setter = isReadOnly ? BambooFileAttributes.SET_READONLY : BambooFileAttributes.SET_WRITABLE;
        setter.accept(path);
    }

    public static void setExecutable(Path path, boolean isExecutable) throws IOException {
        BambooFileAttributes.FileAttributeVisitor setter = isExecutable ? BambooFileAttributes.SET_EXECUTABLE : BambooFileAttributes.SET_NON_EXECUTABLE;
        setter.accept(path);
    }

    public static void setAccessibleOnlyByOwner(@NotNull Path path) throws IOException {
        BambooFileAttributes.FileAttributeVisitor retainOwnerRights = new BambooFileAttributes.FileAttributeVisitor(){

            @Override
            public void visitPosix(PosixFileAttributeView posixFileAttributeView) throws IOException {
                Set<PosixFilePermission> permissions = posixFileAttributeView.readAttributes().permissions();
                permissions.retainAll(BambooFileAttributes.OWNER_PERMISSIONS);
                posixFileAttributeView.setPermissions(permissions);
            }

            @Override
            public void visitDos(DosFileAttributeView dosFileAttributeView) {
            }

            @Override
            void visitAcl(AclFileAttributeView aclView) throws IOException {
                UserPrincipal fileOwner = aclView.getOwner();
                List<AclEntry> aclEntries = aclView.getAcl();
                aclEntries.removeIf(entry -> !entry.principal().equals(fileOwner));
                aclView.setAcl(aclEntries);
            }
        };
        retainOwnerRights.accept(path);
    }

    public static Path resolvePathUnderParent(@NotNull Path parent, @NotNull String child) {
        Path normalisedParent = parent.normalize();
        Path resolved = normalisedParent.resolve(child).normalize();
        if (!resolved.startsWith(normalisedParent)) {
            throw new IllegalArgumentException("Creation of " + child + " under " + String.valueOf(parent) + " would result in parent directory traversal");
        }
        return resolved;
    }

    public static Path ensureEmptyDirExists(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            BambooPathUtils.cleanDirectory(dir);
        } else {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }

    public static interface QuietlyRemoved
    extends AutoRemoved {
        @Override
        public void close();
    }

    public static interface AutoRemoved
    extends AutoCloseable {
        @Override
        public void close() throws IOException;

        public Path getPath();
    }
}

