/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BambooFileAttributes {
    public static final Set<PosixFilePermission> OWNER_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    private static final Set<PosixFilePermission> POSIX_WRITE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);
    private static final Set<PosixFilePermission> POSIX_EXECUTABLE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE);
    static final FileAttributeVisitor SET_READONLY = new ReadOnlyPermissionSetter(true);
    static final FileAttributeVisitor SET_WRITABLE = new ReadOnlyPermissionSetter(false);
    static final FileAttributeVisitor SET_EXECUTABLE = new ExecutablePermissionSetter(true);
    static final FileAttributeVisitor SET_NON_EXECUTABLE = new ExecutablePermissionSetter(false);

    private static final class ReadOnlyPermissionSetter
    extends FileAttributeVisitor {
        private final boolean isReadOnly;

        private ReadOnlyPermissionSetter(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        @Override
        public void visitPosix(PosixFileAttributeView posixFileAttributeView) throws IOException {
            Set<PosixFilePermission> permissions = posixFileAttributeView.readAttributes().permissions();
            if (this.isReadOnly) {
                permissions.removeAll(POSIX_WRITE_PERMISSIONS);
            } else {
                permissions.addAll(POSIX_WRITE_PERMISSIONS);
            }
            posixFileAttributeView.setPermissions(permissions);
        }

        @Override
        public void visitDos(DosFileAttributeView dosFileAttributeView) throws IOException {
            dosFileAttributeView.setReadOnly(this.isReadOnly);
        }

        @Override
        void visitAcl(AclFileAttributeView aclView) {
        }
    }

    static abstract class FileAttributeVisitor {
        FileAttributeVisitor() {
        }

        public void accept(Path path) throws IOException {
            AclFileAttributeView fileAttributeView;
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView != null) {
                this.visitPosix(posixFileAttributeView);
                return;
            }
            boolean viewFound = false;
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosFileAttributeView != null) {
                this.visitDos(dosFileAttributeView);
                viewFound = true;
            }
            if ((fileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0])) != null) {
                this.visitAcl(fileAttributeView);
                viewFound = true;
            }
            if (!viewFound) {
                throw new UnsupportedOperationException("Don't know how to handle attributes for " + String.valueOf(path.getFileSystem().provider().getClass()));
            }
        }

        abstract void visitAcl(AclFileAttributeView var1) throws IOException;

        abstract void visitDos(DosFileAttributeView var1) throws IOException;

        abstract void visitPosix(PosixFileAttributeView var1) throws IOException;
    }

    private static final class ExecutablePermissionSetter
    extends FileAttributeVisitor {
        private final boolean isExecutable;

        ExecutablePermissionSetter(boolean isExecutable) {
            this.isExecutable = isExecutable;
        }

        @Override
        public void visitPosix(PosixFileAttributeView posixFileAttributeView) throws IOException {
            Set<PosixFilePermission> permissions = posixFileAttributeView.readAttributes().permissions();
            if (this.isExecutable) {
                permissions.addAll(POSIX_EXECUTABLE_PERMISSIONS);
            } else {
                permissions.removeAll(POSIX_EXECUTABLE_PERMISSIONS);
            }
            posixFileAttributeView.setPermissions(permissions);
        }

        @Override
        public void visitDos(DosFileAttributeView dosFileAttributeView) {
        }

        @Override
        void visitAcl(AclFileAttributeView aclView) {
        }
    }

    static final class ExecutablePermissionGetter
    extends FileAttributeVisitor {
        private Boolean executable;

        ExecutablePermissionGetter() {
        }

        @Override
        public void visitPosix(PosixFileAttributeView posixFileAttributeView) throws IOException {
            Set<PosixFilePermission> permissions = posixFileAttributeView.readAttributes().permissions();
            this.executable = permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) || permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) || permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
        }

        @Override
        void visitAcl(AclFileAttributeView aclView) {
        }

        @Override
        public void visitDos(DosFileAttributeView dosFileAttributeView) {
            this.executable = true;
        }

        @Nullable
        Boolean isExecutable() {
            return this.executable;
        }
    }
}

