/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.utils.concurrent.DecayingBooleanImpl;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BambooDebugUtils {
    private static final Logger emergencyLog = LogManager.getLogger((String)"Emergency");

    private BambooDebugUtils() {
    }

    public static String getAllStackTraces(ThreadDumpReason reason) {
        if (reason.isThreadDumpBlocked()) {
            return "Not dumping threads as less than 5 minutes passes since the last dump for reason " + String.valueOf((Object)reason);
        }
        reason.temporarilyBlockThreadDumps();
        StringBuilder sb = new StringBuilder();
        sb.append(BambooDebugUtils.getThreadDumpHeaderInJstackFormat()).append("\n\n");
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : allStackTraces.entrySet()) {
            Thread thread = threadEntry.getKey();
            sb.append(BambooDebugUtils.getThreadHeaderInJstackFormat(thread)).append('\n').append(BambooDebugUtils.getThreadStateInJstackFormat(thread)).append('\n');
            Object[] stackTrace = threadEntry.getValue();
            if (stackTrace.length != 0) {
                sb.append("\tat ").append(Joiner.on((String)"\n\tat ").join(stackTrace));
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private static String getThreadDumpHeaderInJstackFormat() {
        return String.format("Full thread dump %s (%s %s)", SystemUtils.JAVA_VM_NAME, SystemUtils.JAVA_VM_VERSION, SystemUtils.JAVA_VM_INFO);
    }

    private static String getThreadStateInJstackFormat(Thread thread) {
        return String.format("    %s: %s", new Object[]{((Object)((Object)thread.getState())).getClass().getCanonicalName(), thread.getState()});
    }

    private static String getThreadHeaderInJstackFormat(Thread thread) {
        String daemon = thread.isDaemon() ? "daemon " : "";
        long fakeNid = thread.getId();
        int fakePointer = System.identityHashCode(thread);
        return String.format("\"%s\" %sprio=%d tid=0x%016x nid=0x%x %s [%x]", thread.getName(), daemon, thread.getPriority(), thread.getId(), fakeNid, thread.getState().name().toLowerCase(), fakePointer);
    }

    public static void dumpHeap(File file) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.substring(0, name.indexOf("@"));
        if (file.exists()) {
            Preconditions.checkState((boolean)file.delete());
        }
        String[] cmd = new String[]{"jmap", "-dump:file=" + String.valueOf(file), pid};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Logger emergencyLog() {
        return emergencyLog;
    }

    private void printStateOfObject(String name, Object object, final boolean logExceptions) {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(object, (ToStringStyle)new MultilineRecursiveToStringStyle()){

            protected void appendFieldsIn(Class<?> clazz) {
                block2: {
                    try {
                        super.appendFieldsIn(clazz);
                    }
                    catch (Exception e) {
                        if (!logExceptions) break block2;
                        BambooDebugUtils.emergencyLog().error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        emergencyLog.info("State of the object \"{}\" :\n{}", (Object)name, (Object)reflectionToStringBuilder);
    }

    public static enum ThreadDumpReason {
        QUEUE_TIMEOUT,
        MQ_SEND_TIMEOUT,
        AGENT_STOP,
        HEARTBEAT_WATCHDOG,
        OTHER;

        private final DecayingBooleanImpl threadDumpBlocked = new DecayingBooleanImpl(false, Duration.ofMinutes(5L));

        public boolean isThreadDumpBlocked() {
            return this.threadDumpBlocked.get();
        }

        public void temporarilyBlockThreadDumps() {
            this.threadDumpBlocked.set(true);
        }
    }
}

