/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.environments;

import com.atlassian.bamboo.specs.api.builders.deployment.Environment;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum ReleaseApprovalPrerequisite {
    NONE("None", "none"),
    NOT_BROKEN("Not broken", "not-broken"),
    APPROVED("Approved", "approved");

    private final String readableValue;
    private final String yamlSpecsValue;

    private ReleaseApprovalPrerequisite(String readableValue, String yamlSpecsValue) {
        this.readableValue = readableValue;
        this.yamlSpecsValue = yamlSpecsValue;
    }

    @NotNull
    public String getReadableValue() {
        return this.readableValue;
    }

    @NotNull
    public String getYamlSpecsValue() {
        return this.yamlSpecsValue;
    }

    public static ReleaseApprovalPrerequisite getInstance(String name) {
        return ReleaseApprovalPrerequisite.valueOf(name.toUpperCase());
    }

    public static ReleaseApprovalPrerequisite getDefault() {
        return NOT_BROKEN;
    }

    public static ReleaseApprovalPrerequisite fromSpecs(Environment.ReleaseApprovalPrerequisite releaseApprovalPrerequisiteSpecs) {
        if (releaseApprovalPrerequisiteSpecs == null) {
            return ReleaseApprovalPrerequisite.getDefault();
        }
        return Arrays.stream(ReleaseApprovalPrerequisite.values()).filter(v -> v.name().equalsIgnoreCase(releaseApprovalPrerequisiteSpecs.name())).findFirst().orElse(ReleaseApprovalPrerequisite.getDefault());
    }

    public static Environment.ReleaseApprovalPrerequisite toSpecs(ReleaseApprovalPrerequisite releaseApprovalPrerequisite) {
        if (releaseApprovalPrerequisite == null) {
            return Environment.ReleaseApprovalPrerequisite.getDefault();
        }
        return Arrays.stream(Environment.ReleaseApprovalPrerequisite.values()).filter(v -> v.name().equalsIgnoreCase(releaseApprovalPrerequisite.name())).findFirst().orElse(Environment.ReleaseApprovalPrerequisite.getDefault());
    }

    public static ReleaseApprovalPrerequisite fromYaml(String input) {
        if (input == null) {
            return ReleaseApprovalPrerequisite.getDefault();
        }
        return Arrays.stream(ReleaseApprovalPrerequisite.values()).filter(v -> v.getYamlSpecsValue().equalsIgnoreCase(input)).findFirst().orElse(ReleaseApprovalPrerequisite.getDefault());
    }

    public static String toYaml(Environment.ReleaseApprovalPrerequisite releaseApprovalPrerequisiteSpecs) {
        return ReleaseApprovalPrerequisite.fromSpecs(releaseApprovalPrerequisiteSpecs).getYamlSpecsValue();
    }

    public static List<ReleaseApprovalPrerequisite> valuesOrderedToDisplay() {
        return Arrays.asList(NOT_BROKEN, APPROVED, NONE);
    }
}

