/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.web;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;

public class HttpHeaders
implements MultiValueMap<String, String>,
Serializable {
    final MultiValueMap<String, String> headers;

    public HttpHeaders() {
        this((MultiValueMap<String, String>)CollectionUtils.toMultiValueMap((Map)new LinkedCaseInsensitiveMap(8, Locale.ENGLISH)));
    }

    public HttpHeaders(MultiValueMap<String, String> headers) {
        Assert.notNull(headers, (String)"MultiValueMap must not be null");
        this.headers = headers;
    }

    public List<String> getOrEmpty(Object headerName) {
        List<String> values = this.get(headerName);
        return values != null ? values : Collections.emptyList();
    }

    @Nullable
    public String getFirst(String headerName) {
        return (String)this.headers.getFirst((Object)headerName);
    }

    public void add(String headerName, @Nullable String headerValue) {
        this.headers.add((Object)headerName, (Object)headerValue);
    }

    public void addAll(String key, List<? extends String> values) {
        this.headers.addAll((Object)key, values);
    }

    public void addAll(MultiValueMap<String, String> values) {
        this.headers.addAll(values);
    }

    public void set(String headerName, @Nullable String headerValue) {
        this.headers.set((Object)headerName, (Object)headerValue);
    }

    public void setAll(Map<String, String> values) {
        this.headers.setAll(values);
    }

    public Map<String, String> toSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Nullable
    public List<String> get(Object key) {
        return (List)this.headers.get(key);
    }

    public List<String> put(String key, List<String> value) {
        return (List)this.headers.put((Object)key, value);
    }

    public List<String> remove(Object key) {
        return (List)this.headers.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        this.headers.putAll(map);
    }

    public void clear() {
        this.headers.clear();
    }

    @NotNull
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @NotNull
    public Collection<List<String>> values() {
        return this.headers.values();
    }

    @NotNull
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaders)) {
            return false;
        }
        return HttpHeaders.unwrap(this).equals(HttpHeaders.unwrap((HttpHeaders)other));
    }

    private static MultiValueMap<String, String> unwrap(HttpHeaders headers) {
        while (headers.headers instanceof HttpHeaders) {
            headers = (HttpHeaders)headers.headers;
        }
        return headers.headers;
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this.headers);
    }

    public static String formatHeaders(MultiValueMap<String, String> headers) {
        return headers.entrySet().stream().map(entry -> {
            List values = (List)entry.getValue();
            return (String)entry.getKey() + ":" + (String)(values.size() == 1 ? "\"" + (String)values.get(0) + "\"" : values.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")));
        }).collect(Collectors.joining(", ", "[", "]"));
    }
}

