/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@ExperimentalApi
public interface BambooSpecsHandler {
    public static final String BAMBOO_SPECS_DIRECTORY = BambooConstantUtils.preventInlining("bamboo-specs");
    public static final List<String> BAMBOO_YAML_FILES = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("bamboo.yml");
            this.add("bamboo.yaml");
        }
    });

    @NotNull
    public Optional<String> detectSpecRevision(@NotNull VcsRepositoryData var1, @NotNull Object var2) throws RepositoryException;

    public boolean isNewer(@NotNull VcsRepositoryData var1, @NotNull String var2, @NotNull String var3) throws RepositoryException;

    @NotNull
    public List<CommitContext> findCommitsToSpecs(@NotNull VcsRepositoryData var1, @NotNull String var2, @NotNull String var3) throws RepositoryException;

    public boolean isWebhookRequired();

    default public boolean supportsDivergentBranches() {
        return false;
    }

    default public boolean divergentBranchesEnabled(@NotNull VcsRepositoryData vcsRepositoryData) {
        return this.supportsDivergentBranches();
    }
}

