/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.utils.Validations;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementAware;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementAwareMapping;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class RequirementImmutablePlanMapping
implements RequirementAwareMapping {
    private final Requirement requirement;
    private final LazyReference<Optional<ImmutableJob>> jobRef;
    private final PlanKey jobKey;

    public RequirementImmutablePlanMapping(final @NotNull CachedPlanManager cachedPlanManager, @NotNull Requirement requirement, final @NotNull PlanKey jobKey) {
        Validations.checkState(PlanKeys.isJobKey(jobKey));
        this.requirement = requirement;
        this.jobKey = jobKey;
        this.jobRef = new LazyReference<Optional<ImmutableJob>>(){

            protected Optional<ImmutableJob> create() {
                ImmutableJob job = cachedPlanManager.getPlanByKey(jobKey, ImmutableJob.class);
                return Optional.ofNullable(job);
            }
        };
    }

    public RequirementImmutablePlanMapping(@NotNull Requirement requirement, final @NotNull ImmutableJob job) {
        this.requirement = requirement;
        this.jobRef = new LazyReference<Optional<ImmutableJob>>(){

            protected Optional<ImmutableJob> create() {
                return Optional.of(job);
            }
        };
        this.jobKey = job.getPlanKey();
    }

    @Override
    public Requirement getRequirement() {
        return this.requirement;
    }

    @Override
    public RequirementAware getRequirementAware() {
        return ((Optional)this.jobRef.get()).map(j -> new RequirementAware(j.getName(), j)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementImmutablePlanMapping that = (RequirementImmutablePlanMapping)o;
        return Objects.equals(this.requirement.getKey(), that.requirement.getKey()) && Objects.equals(this.requirement.getPluginModuleKey(), that.requirement.getPluginModuleKey()) && Objects.equals(this.requirement.getMatchValue(), that.requirement.getMatchValue()) && Objects.equals(this.requirement.isReadonly(), that.requirement.isReadonly()) && Objects.equals(this.jobKey, that.jobKey);
    }

    public int hashCode() {
        return Objects.hash(this.requirement.getKey(), this.requirement.getMatchValue(), this.requirement.isReadonly(), this.requirement.getPluginModuleKey(), this.jobKey);
    }
}

