/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.utils.Which;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutablePathUtils {
    private static final Logger log = LogManager.getLogger(ExecutablePathUtils.class);
    private static final String DOT_BAT = ".bat";
    private static final String DOT_CMD = ".cmd";
    private static final String BIN = "bin";
    private static final List<String> MAVEN_EXECUTABLE = Arrays.asList("maven", "mvn");

    private ExecutablePathUtils() {
    }

    public static boolean existsInHomeBinExePattern(@Nullable String homePath, @NotNull String executableName) {
        return ExecutablePathUtils.getExistingExecutable(homePath, executableName) != null;
    }

    public static Optional<File> getExistingExecutable(@Nullable String basePath, @NotNull String executableName) {
        if (basePath == null) {
            return Optional.empty();
        }
        File executable = ExecutablePathUtils.getExecutable(basePath, executableName);
        return executable.exists() ? Optional.of(executable) : Optional.empty();
    }

    @NotNull
    private static File getExecutable(@NotNull String homePath, @NotNull String executableName) {
        StringBuilder builder = new StringBuilder(homePath).append(File.separator).append(BIN).append(File.separator).append(executableName);
        return new File(builder.toString());
    }

    @NotNull
    public static String makeBatchIfOnWindows(String builder) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return builder;
        }
        String batPath = builder + DOT_BAT;
        if (MAVEN_EXECUTABLE.contains(builder)) {
            String cmdPath = ExecutablePathUtils.findExecutablePath(builder + DOT_CMD);
            log.debug("Matching maven executable '{}' to find '{}' and found: '{}'", MAVEN_EXECUTABLE, (Object)(builder + DOT_CMD), (Object)cmdPath);
            return cmdPath != null ? builder + DOT_CMD : batPath;
        }
        return batPath;
    }

    @Nullable
    public static File detectExecutableOnPath(@NotNull String executableName) {
        File file;
        String executablePath = Which.execute(executableName);
        if (StringUtils.isNotEmpty((CharSequence)executablePath) && (file = new File(executablePath)).canExecute()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                log.warn("", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static File getHomeFromExecutableInHomeBin(@NotNull File executable) {
        File parent = executable.getParentFile();
        if (parent.isDirectory() && parent.getName().equals(BIN)) {
            return parent.getParentFile();
        }
        return null;
    }

    @Nullable
    public static File findExecutable(@NotNull String executableName, @Nullable Predicate<File> validityPredicate, @Nullable String envHomeDir, @Nullable String fhsHome) {
        return ExecutablePathUtils.findExecutable(executableName, validityPredicate, envHomeDir, fhsHome != null ? Collections.singletonList(fhsHome) : Collections.emptyList());
    }

    @Nullable
    public static File findExecutable(@NotNull String executableName, @Nullable Predicate<File> validityPredicate, @Nullable String envHomeDir, @NotNull List<String> fhsHomes) {
        Optional<File> optCandidate;
        if (validityPredicate == null) {
            validityPredicate = Objects::nonNull;
        }
        if ((optCandidate = ExecutablePathUtils.getExistingExecutable(envHomeDir, executableName).filter(validityPredicate)).isPresent()) {
            return optCandidate.get();
        }
        File executablePathCandidate = ExecutablePathUtils.detectExecutableOnPath(executableName);
        if (executablePathCandidate != null && validityPredicate.test(executablePathCandidate)) {
            return executablePathCandidate;
        }
        for (String fhsHome : fhsHomes) {
            File candidate = ExecutablePathUtils.getExistingExecutable(fhsHome, executableName).filter(validityPredicate).orElse(null);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String findExecutablePath(@NotNull String executableName) {
        File file = ExecutablePathUtils.detectExecutableOnPath(executableName);
        return file != null ? file.getAbsolutePath() : null;
    }
}

