/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CapabilitySource implements Comparable<CapabilitySource>
{
    UI(1),
    PROPERTIES_FILE(2),
    AUTO_DETECTION(4),
    SHARED(8);

    private final int mask;
    private static final Map<Integer, CapabilitySource> maskToCapabilitySource;

    private CapabilitySource(int mask) {
        this.mask = mask;
    }

    @Nullable
    public static CapabilitySource forName(@NotNull String name) {
        try {
            return CapabilitySource.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public static CapabilitySource getByMask(@Nullable Integer mask) {
        if (mask == null) {
            return null;
        }
        return maskToCapabilitySource.getOrDefault(mask, null);
    }

    public int getMask() {
        return this.mask;
    }

    static {
        maskToCapabilitySource = Arrays.stream(CapabilitySource.values()).collect(Collectors.toUnmodifiableMap(CapabilitySource::getMask, o -> o, (v1, v2) -> v1));
    }
}

