/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build;

import java.io.Serializable;
import java.util.Date;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

@Immutable
@ThreadSafe
public class BuildCancelledDetails
implements Serializable {
    private static final Logger log = Logger.getLogger(BuildCancelledDetails.class);
    private final Date cancellationDate;
    private final boolean forcedCancellation;
    private final ActionSource actionSource;

    public BuildCancelledDetails() {
        this(new Date());
    }

    public BuildCancelledDetails(Date cancellationDate) {
        this(cancellationDate, false);
    }

    public BuildCancelledDetails(Date cancellationDate, boolean forcedCancellation) {
        this(cancellationDate, forcedCancellation, forcedCancellation ? ActionSource.SYSTEM : ActionSource.MANUAL);
    }

    public BuildCancelledDetails(Date cancellationDate, boolean forcedCancellation, ActionSource source) {
        this.cancellationDate = cancellationDate;
        this.forcedCancellation = forcedCancellation;
        this.actionSource = source;
    }

    public Date getCancellationDate() {
        return this.cancellationDate;
    }

    public boolean isForcedCancellation() {
        return this.forcedCancellation;
    }

    public ActionSource getActionSource() {
        return this.actionSource;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 73).append((Object)this.cancellationDate).append(this.forcedCancellation).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildCancelledDetails)) {
            return false;
        }
        BuildCancelledDetails rhs = (BuildCancelledDetails)o;
        return new EqualsBuilder().append((Object)this.cancellationDate, (Object)rhs.cancellationDate).append(this.forcedCancellation, rhs.forcedCancellation).isEquals();
    }

    public static enum ActionSource {
        MANUAL("manually stopped"),
        SYSTEM("stopped by system"),
        HUNG_BUILD_MONITOR("stopped by hung build monitor");

        private final String stoppedHow;

        private ActionSource(String stoppedHow) {
            this.stoppedHow = stoppedHow;
        }

        public String stoppedHow() {
            return this.stoppedHow;
        }
    }
}

