/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.startup;

import com.atlassian.bamboo.exception.StartupException;
import com.atlassian.bamboo.setup.BambooHomeLocator;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PluginSystemStartupUtils {
    private static final Logger log = Logger.getLogger(PluginSystemStartupUtils.class);
    private static final String CRITICAL_PLUGIN_LIST_FILE_NAME = "critical-plugins.lst";
    private static final List<String> CRITICAL_PLUGIN_LIST = ImmutableList.of((Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2", (Object)"com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud", (Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver");

    private PluginSystemStartupUtils() {
    }

    public static void verifyBundledPluginsAvailability(@NotNull PluginAccessor pluginManager, @NotNull BambooHomeLocator bambooHomeLocator) {
        log.info((Object)"Verifying availability of mission critical plugins...");
        List failedPlugins = Stream.concat(CRITICAL_PLUGIN_LIST.stream(), PluginSystemStartupUtils.getCriticalPluginListFromFile(bambooHomeLocator).stream()).filter(s -> pluginManager.getEnabledPluginModule(s) == null).collect(Collectors.toList());
        if (!failedPlugins.isEmpty()) {
            String message = "Mission critical plugins did not start: " + Joiner.on((String)", ").join(failedPlugins);
            log.fatal((Object)message);
            throw new StartupException(message);
        }
        log.info((Object)"All mission critical plugins have started.");
    }

    @NotNull
    private static List<String> getCriticalPluginListFromFile(@NotNull BambooHomeLocator bambooHomeLocator) {
        ArrayList<String> arrayList;
        String sharedHome = bambooHomeLocator.getSharedHomePath();
        if (StringUtils.isBlank((CharSequence)sharedHome)) {
            log.debug((Object)"Shared home is blank");
            return Collections.emptyList();
        }
        Path criticalPluginListFilePath = Paths.get(sharedHome, CRITICAL_PLUGIN_LIST_FILE_NAME);
        File criticalPluginListFile = criticalPluginListFilePath.toFile();
        if (!criticalPluginListFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User defined list of critical plugins not found at " + criticalPluginListFile.getAbsolutePath()));
            }
            return Collections.emptyList();
        }
        BufferedReader reader = new BufferedReader(new FileReader(criticalPluginListFile));
        try {
            ArrayList<String> result = new ArrayList<String>();
            reader.lines().filter(StringUtils::isNotBlank).map(String::trim).forEach(result::add);
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn((Object)"", (Throwable)e);
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }
}

