/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DatabaseType {
    HSQL("hsql", "database.type.hsql", "jdbc:hsqldb", "org.hsqldb.jdbcDriver", 0, true, dialect -> dialect.contains("hsql")){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s:%2$s/database/defaultdb", this.getProtocol(), "${bambooHome}");
        }
    }
    ,
    MSSQL("mssql", "database.type.mssql", "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", 1433, false, dialect -> dialect.contains(".SQLServer")){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d;databaseName=%4$s;trustServerCertificate=true", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    MYSQL("mysql", "database.type.mysql", "jdbc:mysql", "com.mysql.cj.jdbc.Driver", 3306, false, dialect -> dialect.contains("MySQL")){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s?characterEncoding=utf8&useUnicode=true", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    ORACLE("oracle", "database.type.oracle", "jdbc:oracle:thin", "oracle.jdbc.OracleDriver", 1521, false, dialect -> dialect.contains("Oracle")){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String service, int port) {
            return String.format("%1$s:@//%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, service);
        }
    }
    ,
    POSTGRESQL("postgres", "database.type.postgresql", "jdbc:postgresql", "org.postgresql.Driver", 5432, false, dialect -> dialect.contains("PostgreSQL")){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    H2("h2", "database.type.h2", "jdbc:h2", "org.h2.Driver", 9092, true, dialect -> dialect.contains("H2")){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, database);
        }
    };

    private final String key;
    private final String i18nKey;
    private final String protocol;
    private final String driverClassName;
    private final int defaultPort;
    private final boolean embedded;
    private final Function<String, Boolean> dialectMatcher;

    private DatabaseType(String key, String i18nKey, String protocol, String driverClassName, int defaultPort, boolean embedded, Function<String, Boolean> dialectMatcher) {
        this.key = key;
        this.i18nKey = i18nKey;
        this.protocol = protocol;
        this.driverClassName = driverClassName;
        this.defaultPort = defaultPort;
        this.embedded = embedded;
        this.dialectMatcher = dialectMatcher;
    }

    public static DatabaseType fromDialect(@NotNull String hibernateDialect) {
        for (DatabaseType value : DatabaseType.values()) {
            if (!value.dialectMatcher.apply(hibernateDialect).booleanValue()) continue;
            return value;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    @NotNull
    public String generateUrl(@NotNull String hostName, @NotNull String database) {
        return this.generateUrl(hostName, database, this.defaultPort);
    }

    @NotNull
    public abstract String generateUrl(@NotNull String var1, @NotNull String var2, int var3);
}

