/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection.multimap;

import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public final class TreeMultimap<K, V>
implements Multimap<K, V> {
    private final Map<K, Collection<V>> map;
    private final Comparator<? super K> keyComparator;
    private final Comparator<? super V> valueComparator;

    public TreeMultimap(@Nullable Comparator<? super K> keyComparator, @Nullable Comparator<? super V> valueComparator) {
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
        this.map = TreeMultimap.getExternalMap(keyComparator);
    }

    private static <K, V> Map<K, Collection<V>> getExternalMap(@Nullable Comparator<? super K> comparator) {
        return comparator != null ? new TreeMap(comparator) : new LinkedHashMap();
    }

    private static <V> Collection<V> getInternalCollection(@Nullable Comparator<? super V> comparator) {
        return comparator != null ? new TreeSet<V>(comparator) : new LinkedHashSet();
    }

    public static <K, V> TreeMultimap<K, V> create(Comparator<? super K> keyComparator, Comparator<? super V> valueComparator) {
        return new TreeMultimap<K, V>(keyComparator, valueComparator);
    }

    @Override
    public void put(K key, V value) {
        this.map.computeIfAbsent(key, k -> TreeMultimap.getInternalCollection(this.valueComparator)).add(value);
    }

    @Override
    public void putAll(K key, Collection<? extends V> values) {
        this.map.computeIfAbsent(key, k -> TreeMultimap.getInternalCollection(this.valueComparator)).addAll(values);
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.getOrDefault(key, TreeMultimap.getInternalCollection(this.valueComparator));
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            for (V value : entry.getValue()) {
                entries.add(new AbstractMap.SimpleEntry<K, V>(entry.getKey(), value));
            }
        }
        return entries;
    }

    @Override
    public void remove(K key, V value) {
        if (this.map.containsKey(key)) {
            this.map.get(key).remove(value);
            if (this.map.get(key).isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    @Override
    public void removeAll(K key) {
        this.map.remove(key);
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<V> values : this.map.values()) {
            size += values.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> allValues = new ArrayList<V>();
        for (Collection<V> values : this.map.values()) {
            allValues.addAll(values);
        }
        return allValues;
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<? super V>>> asMapView = TreeMultimap.getExternalMap(this.keyComparator);
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            Collection<V> values = TreeMultimap.getInternalCollection(this.valueComparator);
            values.addAll(entry.getValue());
            asMapView.put(entry.getKey(), values);
        }
        return asMapView;
    }

    @Override
    public Multimap<K, V> copy() {
        TreeMultimap<K, V> copy = new TreeMultimap<K, V>(this.keyComparator, this.valueComparator);
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            for (V value : entry.getValue()) {
                copy.put(entry.getKey(), value);
            }
        }
        return copy;
    }

    @Override
    public TreeMultimap<V, K> inverse() {
        TreeMultimap<K, V> inverseMap = TreeMultimap.create(this.valueComparator, this.keyComparator);
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            K originalKey = entry.getKey();
            for (V value : entry.getValue()) {
                inverseMap.put(value, originalKey);
            }
        }
        return inverseMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMultimap that = (TreeMultimap)o;
        return Objects.equals(this.map, that.map) && Objects.equals(this.keyComparator, that.keyComparator) && Objects.equals(this.valueComparator, that.valueComparator);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.keyComparator, this.valueComparator);
    }
}

