/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection.multimap;

import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ListMultimap<K, V>
implements Multimap<K, V> {
    private Map<K, List<V>> map = new HashMap<K, List<V>>();

    public static <K, V> ListMultimap<K, V> create() {
        return new ListMultimap<K, V>();
    }

    public static <K, V> ListMultimap<K, V> create(Multimap<K, V> multimap) {
        ListMultimap<K, V> newListMultimap = new ListMultimap<K, V>();
        for (K key : multimap.keySet()) {
            Collection<V> values = multimap.get(key);
            for (V value : values) {
                newListMultimap.put(key, value);
            }
        }
        return newListMultimap;
    }

    public static <K, V> ListMultimap<K, V> of(K key, V value) {
        ListMultimap<K, V> listMultimap = ListMultimap.create();
        listMultimap.put(key, value);
        return listMultimap;
    }

    public static <K, V> ListMultimap<K, V> of(K key, V value, K key1, V value1) {
        ListMultimap<K, V> listMultimap = ListMultimap.create();
        listMultimap.put(key, value);
        listMultimap.put(key1, value1);
        return listMultimap;
    }

    public static <K, V> ListMultimap<K, V> of(K key, V value, K key1, V value1, K key2, V value2) {
        ListMultimap<K, V> listMultimap = ListMultimap.create();
        listMultimap.put(key, value);
        listMultimap.put(key1, value1);
        listMultimap.put(key2, value2);
        return listMultimap;
    }

    @Override
    public void put(K key, V value) {
        this.map.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    @Override
    public void putAll(K key, Collection<? extends V> values) {
        this.map.computeIfAbsent(key, k -> new ArrayList()).addAll(values);
    }

    @Override
    public List<V> get(K key) {
        return this.map.getOrDefault(key, new ArrayList());
    }

    @Override
    public void remove(K key, V value) {
        if (this.map.containsKey(key)) {
            this.map.get(key).remove(value);
            if (this.map.get(key).isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    @Override
    public void removeAll(K key) {
        this.map.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Collection<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public ListMultimap<K, V> copy() {
        ListMultimap<K, V> copy = new ListMultimap<K, V>();
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            copy.map.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            for (V value : entry.getValue()) {
                entries.add(new AbstractMap.SimpleEntry<K, V>(key, value));
            }
        }
        return entries;
    }

    @Override
    public int size() {
        int size = 0;
        for (List<V> valueSet : this.map.values()) {
            size += valueSet.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return new HashMap<K, List<V>>(this.map);
    }

    @Override
    public ListMultimap<V, K> inverse() {
        HashMap<Object, List> tempMap = new HashMap<Object, List>();
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K originalKey = entry.getKey();
            for (V value : entry.getValue()) {
                tempMap.computeIfAbsent(value, k -> new ArrayList()).add(originalKey);
            }
        }
        ListMultimap inverseMap = ListMultimap.create();
        for (Map.Entry entry : tempMap.entrySet()) {
            Object value = entry.getKey();
            for (Object originalKey : (List)entry.getValue()) {
                inverseMap.put(value, originalKey);
            }
        }
        return inverseMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMultimap that = (ListMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

