/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection.multimap;

import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.collection.multimap.ImmutableMultimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ImmutableListMultimap<K, V>
implements ImmutableMultimap<K, V> {
    private final Map<K, List<V>> map = new HashMap<K, List<V>>();

    public static <K, V> ImmutableListMultimap<K, V> create() {
        return new ImmutableListMultimap<K, V>();
    }

    public static <K, V> ImmutableListMultimap<K, V> of(Collection<Pair<K, V>> input) {
        ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.create();
        HashMap<Object, List> groupedMap = new HashMap<Object, List>();
        for (Pair<K, V> pair : input) {
            K key = pair.getFirst();
            V value = pair.getSecond();
            groupedMap.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        for (Map.Entry entry : groupedMap.entrySet()) {
            immutableListMultimap.put(entry.getKey(), (List)entry.getValue());
        }
        return immutableListMultimap;
    }

    public static <K, V> ImmutableListMultimap<K, V> of(K key, V value) {
        ImmutableListMultimap<K, V> ImmutableListMultimap2 = ImmutableListMultimap.create();
        ImmutableListMultimap2.put(key, Collections.singletonList(value));
        return ImmutableListMultimap2;
    }

    private void put(K key, List<V> values) {
        this.map.put(key, Collections.unmodifiableList(values));
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.getOrDefault(key, Collections.emptyList());
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Collection<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new AbstractMap.SimpleEntry(entry.getKey(), value))).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.map.values().stream().mapToInt(List::size).sum();
    }

    @Override
    public ImmutableMultimap<K, V> copy() {
        ArrayList<Pair<K, V>> l = new ArrayList<Pair<K, V>>();
        for (Map.Entry<K, V> entry : this.entries()) {
            l.add(Pair.make(entry.getKey(), entry.getValue()));
        }
        return ImmutableListMultimap.of(l);
    }

    @Override
    public ImmutableListMultimap<V, K> inverse() {
        HashMap<Object, List> tempMap = new HashMap<Object, List>();
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K originalKey = entry.getKey();
            for (V value : entry.getValue()) {
                tempMap.computeIfAbsent(value, k -> new ArrayList()).add(originalKey);
            }
        }
        ArrayList<Pair<K, V>> pairs = new ArrayList<Pair<K, V>>();
        for (Map.Entry entry : tempMap.entrySet()) {
            Object value = entry.getKey();
            for (Object key : (List)entry.getValue()) {
                pairs.add(Pair.make(value, key));
            }
        }
        return ImmutableListMultimap.of(pairs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableListMultimap that = (ImmutableListMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

