/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;

public abstract class RecentLazyReference<T>
implements Supplier<T> {
    private final ResettableLazyReference<T> lazyReference = this.newLazyReference();
    private volatile RecentPredicate recentPredicate;

    public RecentLazyReference(long amount, TimeUnit unit) {
        this.setRecentPredicate(amount, unit);
    }

    public RecentLazyReference(RecentPredicate recentPredicate) {
        this.setRecentPredicate(recentPredicate);
    }

    public void setRecentPredicate(long amount, TimeUnit unit) {
        this.recentPredicate = new RecentPredicateImpl(amount, unit);
    }

    public void setRecentPredicate(RecentPredicate recentPredicate) {
        this.recentPredicate = recentPredicate;
    }

    @Override
    public synchronized T get() {
        if (!this.recentPredicate.apply(new Date())) {
            this.lazyReference.reset();
        }
        return (T)this.lazyReference.get();
    }

    protected abstract T createInstance() throws Exception;

    @NotNull
    private ResettableLazyReference<T> newLazyReference() {
        return new ResettableLazyReference<T>(){

            protected T create() throws Exception {
                Object object = RecentLazyReference.this.createInstance();
                RecentLazyReference.this.recentPredicate.reset();
                return object;
            }
        };
    }

    public static interface RecentPredicate
    extends Predicate<Date> {
        public boolean apply(@NotNull Date var1);

        public void reset();

        @Override
        default public boolean test(@NotNull Date date) {
            return this.apply(date);
        }
    }

    private static class RecentPredicateImpl
    implements RecentPredicate {
        private final long amount;
        private final TimeUnit unit;
        private Date nextRefreshTime;

        public RecentPredicateImpl(long amount, @NotNull TimeUnit unit) {
            this.amount = amount;
            this.unit = unit;
        }

        @Override
        public void reset() {
            this.nextRefreshTime = DateUtils.addMilliseconds((Date)new Date(), (int)((int)this.unit.toMillis(this.amount)));
        }

        @Override
        public boolean apply(@NotNull Date date) {
            return this.nextRefreshTime != null && date.before(this.nextRefreshTime);
        }
    }
}

