/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.Validations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range<E extends Number> {
    private final E min;
    private final E max;

    public static <E extends Number> Range<E> make(@NotNull E min, @NotNull E max) {
        Validations.checkNotNull(min, "Minimum must not be null");
        Validations.checkNotNull(max, "Maximum must not be null");
        Validations.checkArgument(((Comparable)((Object)max)).compareTo(min) >= 0, "Maximum must not be lower than minimum", new Object[0]);
        return new Range<E>(min, max);
    }

    @Deprecated
    public Range(@Nullable E min, @Nullable E max) {
        this.min = min;
        this.max = max;
    }

    public E getMinimum() {
        return this.min;
    }

    public E getMaximum() {
        return this.max;
    }

    boolean isValueInRange(E value) {
        return ((Comparable)value).compareTo(this.min) >= 0 && ((Comparable)value).compareTo(this.max) <= 0;
    }
}

