/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.annotations.Internal;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Execute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public abstract class AbstractSystemProperty {
    private static Logger log = Logger.getLogger(AbstractSystemProperty.class);
    protected String myPropertyValue;
    protected String myPropertyKey;

    protected AbstractSystemProperty(boolean mandatory, String ... properties) {
        for (String property : properties) {
            this.myPropertyValue = AbstractSystemProperty.getEnvironmentVariable(property, mandatory);
            if (this.myPropertyValue == null) continue;
            this.myPropertyKey = property;
            break;
        }
        if (this.myPropertyKey == null && properties.length == 1) {
            this.myPropertyKey = properties[0];
        }
    }

    @VisibleForTesting
    protected AbstractSystemProperty(String property, boolean mandatory, Logger log) {
        AbstractSystemProperty.log = log;
        this.myPropertyValue = AbstractSystemProperty.getEnvironmentVariable(property, mandatory);
    }

    public int getValue(int defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getValue(long defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String toString() {
        return this.getKey();
    }

    @Nullable
    public String getValue() {
        return this.myPropertyValue;
    }

    public String getKey() {
        return this.myPropertyKey;
    }

    @NotNull
    public String getValue(@NotNull String defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue;
    }

    public boolean getValue(boolean defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue.equals("true");
    }

    public void setValue(String propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public boolean exists() {
        return StringUtils.isNotEmpty((CharSequence)this.getValue());
    }

    @Nullable
    private static String obtainVariableFromSystemEnvironment(@NotNull String variable) {
        String envVar = AbstractSystemProperty.getEnvVariableCaseSensitive(variable);
        if (envVar != null) {
            return envVar;
        }
        return AbstractSystemProperty.getPropertyFromAntEnv(variable);
    }

    private static String getEnvVariableCaseSensitive(String variable) {
        return System.getenv().get(variable);
    }

    @Nullable
    static String getPropertyFromAntEnv(@NotNull String variable) {
        Object o = Execute.getEnvironmentVariables().get(variable);
        return o != null ? o.toString() : null;
    }

    @Nullable
    protected static String getEnvironmentVariable(@NotNull String variable, boolean mandatory) {
        String value = System.getProperty(variable);
        if (value == null) {
            try {
                value = AbstractSystemProperty.obtainVariableFromSystemEnvironment(variable);
            }
            catch (Exception throwable) {
                log.error((Object)("Could not access the system environment variable:\"" + variable + "\""), (Throwable)throwable);
                return null;
            }
        }
        if (value == null && mandatory) {
            log.error((Object)("Cannot find the " + variable + " environment variable"));
        }
        return value;
    }
}

