/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BambooProfilingUtils {
    private BambooProfilingUtils() {
    }

    public static String getTimes(@NotNull Map<Object, Long> profiledCalls, int minimumDurationMs) {
        StringBuilder sb = new StringBuilder();
        sb.append("Total calls: ").append(profiledCalls.size()).append("\n");
        sb.append("Accumulated times longer than ").append(minimumDurationMs).append(" ms:\n");
        BambooProfilingUtils.dumpAccumulatedTimes(sb, profiledCalls, minimumDurationMs);
        sb.append("\nIndividual times longer than ").append(minimumDurationMs).append(" ms:\n");
        BambooProfilingUtils.dumpSortedTimes(sb, profiledCalls, minimumDurationMs);
        return sb.toString();
    }

    private static void dumpAccumulatedTimes(@NotNull StringBuilder sb, @NotNull Map<Object, Long> profiledCalls, int longerThanMs) {
        HashMap<Object, Long> profiledAccumulatedCalls = new HashMap<Object, Long>();
        for (Map.Entry<Object, Long> profileEntry : profiledCalls.entrySet()) {
            String profiledObjectName = BambooProfilingUtils.genNameFromToString(profileEntry.getKey());
            Long oldValue = (Long)profiledAccumulatedCalls.get(profiledObjectName);
            if (oldValue == null) {
                oldValue = 0L;
            }
            profiledAccumulatedCalls.put(profiledObjectName, oldValue + profileEntry.getValue());
        }
        BambooProfilingUtils.dumpSortedTimes(sb, profiledAccumulatedCalls, longerThanMs);
    }

    private static void dumpSortedTimes(@NotNull StringBuilder sb, @NotNull Map<Object, Long> profiledCalls, int longerThanMs) {
        long longerThanNs = TimeUnit.MILLISECONDS.toNanos(longerThanMs);
        profiledCalls.entrySet().stream().filter(e -> (Long)e.getValue() >= longerThanNs).map(e -> new ProfileEntry(e.getKey(), (Long)e.getValue())).sorted((o1, o2) -> o2.getTime().compareTo(o1.getTime())).map(ProfileEntry::toString).forEach(s -> sb.append((String)s).append("\n"));
    }

    private static String genNameFromToString(@NotNull Object object) {
        String firstLine = StringUtils.substringBefore((String)StringUtils.substringBefore((String)object.toString(), (String)"\n"), (String)"\r");
        return StringUtils.substringBeforeLast((String)firstLine, (String)"@");
    }

    private static class ProfileEntry {
        private static final long DISPLAY_AS_MILLISECONDS = TimeUnit.MILLISECONDS.toNanos(2L);
        private static final long DISPLAY_AS_MICROSECONDS = TimeUnit.MICROSECONDS.toNanos(2L);
        private final Object object;
        private final Long time;

        public ProfileEntry(Object object, Long time) {
            this.object = object;
            this.time = time;
        }

        public Long getTime() {
            return this.time;
        }

        public String toString() {
            return this.getName() + " : " + this.getPrettyTime(this.time);
        }

        private String getName() {
            return BambooProfilingUtils.genNameFromToString(this.object);
        }

        private String getPrettyTime(long nanos) {
            if (nanos > DISPLAY_AS_MILLISECONDS) {
                return TimeUnit.NANOSECONDS.toMillis(nanos) + " ms";
            }
            if (nanos > DISPLAY_AS_MICROSECONDS) {
                return TimeUnit.NANOSECONDS.toMicros(nanos) + " MICROs";
            }
            return nanos + " NANOs";
        }
    }
}

