/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class BambooFile
extends File {
    @VisibleForTesting
    static final String CONTAINS_TRAVERSAL_CHARS_MSG = "The child part of file path contains directory traversal chars";
    @VisibleForTesting
    static final String STARTS_WITH_SLASH_MSG = "The child part of file path is absolute, starts with a slash";

    public BambooFile(String parent, @NotNull String child) {
        super(parent, child);
        BambooFile.validate(child);
    }

    public BambooFile(File parent, @NotNull String child) {
        super(parent, child);
        BambooFile.validate(child);
    }

    private static void validate(String childPath) throws IllegalStateException {
        if (BambooFilenameUtils.containsDirectoryTraversalString(childPath)) {
            throw new IllegalStateException(CONTAINS_TRAVERSAL_CHARS_MSG);
        }
        if (childPath.startsWith("\\") || childPath.startsWith("/") || SystemUtils.IS_OS_WINDOWS && (childPath.contains(":\\") || childPath.contains(":/"))) {
            throw new IllegalStateException(STARTS_WITH_SLASH_MSG);
        }
    }
}

